/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.sql.internal;

import org.hibernate.metamodel.mapping.DiscriminatorMapping;
import org.hibernate.metamodel.mapping.EntityDiscriminatorMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.ModelPartContainer;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.model.domain.internal.EmbeddedDiscriminatorSqmPath;
import org.hibernate.metamodel.model.domain.internal.EntityDiscriminatorSqmPath;
import org.hibernate.query.sqm.DiscriminatorSqmPath;
import org.hibernate.query.sqm.internal.SqmMappingModelHelper;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.sql.internal.AbstractSqmPathInterpretation;
import org.hibernate.query.sqm.sql.internal.SqmPathInterpretation;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;

public class DiscriminatorPathInterpretation<T>
extends AbstractSqmPathInterpretation<T> {
    private final Expression expression;

    public DiscriminatorPathInterpretation(NavigablePath navigablePath, DiscriminatorMapping mapping, TableGroup tableGroup, SqlAstCreationState sqlAstCreationState) {
        super(navigablePath, mapping, tableGroup);
        JdbcMapping jdbcMappingToUse = mapping.getJdbcMapping();
        this.expression = this.getDiscriminatorMapping().resolveSqlExpression(navigablePath, jdbcMappingToUse, tableGroup, sqlAstCreationState);
    }

    public DiscriminatorPathInterpretation(NavigablePath navigablePath, EntityMappingType mapping, TableGroup tableGroup, SqlAstCreationState sqlAstCreationState) {
        super(navigablePath, mapping.getDiscriminatorMapping(), tableGroup);
        JdbcMapping jdbcMappingToUse = mapping.getDiscriminatorMapping().getJdbcMapping();
        this.expression = this.getDiscriminatorMapping().resolveSqlExpression(navigablePath, jdbcMappingToUse, tableGroup, sqlAstCreationState);
    }

    public static SqmPathInterpretation<?> from(DiscriminatorSqmPath<?> path, SqmToSqlAstConverter converter) {
        NavigablePath navigablePath = path.getNavigablePath();
        TableGroup tableGroup = converter.getFromClauseAccess().getTableGroup(navigablePath.getParent());
        ModelPartContainer modelPart = tableGroup.getModelPart();
        if (path instanceof EntityDiscriminatorSqmPath) {
            assert (((EntityDiscriminatorSqmPath)path).getEntityDescriptor().hasSubclasses());
            EntityMappingType entityMapping = modelPart instanceof EntityValuedModelPart ? ((EntityValuedModelPart)modelPart).getEntityMappingType() : (EntityMappingType)((PluralAttributeMapping)modelPart).getElementDescriptor().getPartMappingType();
            return new DiscriminatorPathInterpretation(navigablePath, entityMapping, tableGroup, (SqlAstCreationState)converter);
        }
        EmbeddedDiscriminatorSqmPath embeddableDiscriminator = (EmbeddedDiscriminatorSqmPath)path;
        DiscriminatorMapping discriminator = (DiscriminatorMapping)SqmMappingModelHelper.resolveMappingModelExpressible(embeddableDiscriminator, converter.getCreationContext().getMappingMetamodel(), converter.getFromClauseAccess()::findTableGroup);
        return new DiscriminatorPathInterpretation(navigablePath, discriminator, tableGroup, (SqlAstCreationState)converter);
    }

    public EntityDiscriminatorMapping getDiscriminatorMapping() {
        return (EntityDiscriminatorMapping)super.getExpressionType();
    }

    @Override
    public EntityDiscriminatorMapping getExpressionType() {
        return this.getDiscriminatorMapping();
    }

    @Override
    public DomainResult<T> createDomainResult(String resultVariable, DomainResultCreationState creationState) {
        return this.getDiscriminatorMapping().createDomainResult(this.getNavigablePath(), this.getTableGroup(), resultVariable, creationState);
    }

    @Override
    public void accept(SqlAstWalker sqlTreeWalker) {
        this.expression.accept(sqlTreeWalker);
    }
}

