/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.produce.function;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.query.sqm.produce.function.FunctionArgumentTypeResolver;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.type.spi.TypeConfiguration;

public final class StandardFunctionArgumentTypeResolvers {
    public static final FunctionArgumentTypeResolver NULL = (arguments, argumentIndex, converter) -> null;
    public static final FunctionArgumentTypeResolver IMPLIED_RESULT_TYPE = (arguments, argumentIndex, converter) -> converter.resolveFunctionImpliedReturnType();
    public static final FunctionArgumentTypeResolver ARGUMENT_OR_IMPLIED_RESULT_TYPE = (arguments, argumentIndex, converter) -> {
        SqmExpression expression;
        MappingModelExpressible<?> expressible;
        Object patt0$temp;
        int i;
        int argumentsSize = arguments.size();
        for (i = 0; i < argumentIndex; ++i) {
            patt0$temp = arguments.get(i);
            if (!(patt0$temp instanceof SqmExpression) || (expressible = converter.determineValueMapping(expression = (SqmExpression)patt0$temp)) == null) continue;
            return expressible;
        }
        for (i = argumentIndex + 1; i < argumentsSize; ++i) {
            patt0$temp = arguments.get(i);
            if (!(patt0$temp instanceof SqmExpression) || (expressible = converter.determineValueMapping(expression = (SqmExpression)patt0$temp)) == null) continue;
            return expressible;
        }
        return converter.resolveFunctionImpliedReturnType();
    };

    private StandardFunctionArgumentTypeResolvers() {
    }

    public static FunctionArgumentTypeResolver invariant(TypeConfiguration typeConfiguration, FunctionParameterType type) {
        MappingModelExpressible<?> expressible = StandardFunctionArgumentTypeResolvers.getMappingModelExpressible(typeConfiguration, type);
        return (arguments, argumentIndex, converter) -> expressible;
    }

    public static FunctionArgumentTypeResolver invariant(TypeConfiguration typeConfiguration, FunctionParameterType ... types) {
        MappingModelExpressible[] expressibles = new MappingModelExpressible[types.length];
        for (int i = 0; i < types.length; ++i) {
            expressibles[i] = StandardFunctionArgumentTypeResolvers.getMappingModelExpressible(typeConfiguration, types[i]);
        }
        return (arguments, argumentIndex, converter) -> argumentIndex < expressibles.length ? expressibles[argumentIndex] : null;
    }

    public static FunctionArgumentTypeResolver invariant(FunctionParameterType ... types) {
        return (arguments, argumentIndex, converter) -> {
            if (argumentIndex >= types.length) {
                return null;
            }
            return StandardFunctionArgumentTypeResolvers.getMappingModelExpressible(converter.getCreationContext().getTypeConfiguration(), types[argumentIndex]);
        };
    }

    public static FunctionArgumentTypeResolver impliedOrInvariant(TypeConfiguration typeConfiguration, FunctionParameterType type) {
        MappingModelExpressible<?> expressible = StandardFunctionArgumentTypeResolvers.getMappingModelExpressible(typeConfiguration, type);
        return (arguments, argumentIndex, converter) -> {
            MappingModelExpressible<?> mappingModelExpressible = converter.resolveFunctionImpliedReturnType();
            return mappingModelExpressible == null ? expressible : mappingModelExpressible;
        };
    }

    public static FunctionArgumentTypeResolver argumentsOrImplied(int ... indices) {
        return (arguments, argumentIndex, converter) -> {
            SqmExpression expression;
            MappingModelExpressible<?> expressible;
            Object patt0$temp;
            int argumentsSize = arguments.size();
            for (int index : indices) {
                if (index >= argumentIndex || index >= argumentsSize) break;
                patt0$temp = arguments.get(index);
                if (!(patt0$temp instanceof SqmExpression) || (expressible = converter.determineValueMapping(expression = (SqmExpression)patt0$temp)) == null) continue;
                return expressible;
            }
            for (int index : indices) {
                if (index <= argumentIndex || index >= argumentsSize) break;
                patt0$temp = arguments.get(index);
                if (!(patt0$temp instanceof SqmExpression) || (expressible = converter.determineValueMapping(expression = (SqmExpression)patt0$temp)) == null) continue;
                return expressible;
            }
            return converter.resolveFunctionImpliedReturnType();
        };
    }

    public static FunctionArgumentTypeResolver composite(FunctionArgumentTypeResolver ... resolvers) {
        return (arguments, argumentIndex, converter) -> {
            for (FunctionArgumentTypeResolver resolver : resolvers) {
                MappingModelExpressible<?> result = resolver.resolveFunctionArgumentType(arguments, argumentIndex, converter);
                if (result == null) continue;
                return result;
            }
            return null;
        };
    }

    public static FunctionArgumentTypeResolver byArgument(FunctionArgumentTypeResolver ... resolvers) {
        return (arguments, argumentIndex, converter) -> argumentIndex < resolvers.length ? resolvers[argumentIndex].resolveFunctionArgumentType(arguments, argumentIndex, converter) : null;
    }

    private static MappingModelExpressible<?> getMappingModelExpressible(TypeConfiguration typeConfiguration, FunctionParameterType type) {
        return switch (type) {
            case FunctionParameterType.STRING, FunctionParameterType.STRING_OR_CLOB -> typeConfiguration.getBasicTypeForJavaType(String.class);
            case FunctionParameterType.NUMERIC -> typeConfiguration.getBasicTypeForJavaType(BigDecimal.class);
            case FunctionParameterType.INTEGER -> typeConfiguration.getBasicTypeForJavaType(Integer.class);
            case FunctionParameterType.TEMPORAL -> typeConfiguration.getBasicTypeForJavaType(Timestamp.class);
            case FunctionParameterType.DATE -> typeConfiguration.getBasicTypeForJavaType(Date.class);
            case FunctionParameterType.TIME -> typeConfiguration.getBasicTypeForJavaType(Time.class);
            case FunctionParameterType.BOOLEAN -> typeConfiguration.getBasicTypeForJavaType(Boolean.class);
            default -> null;
        };
    }
}

