/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results.internal.complete;

import jakarta.persistence.AttributeConverter;
import java.util.Objects;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.query.results.ResultBuilder;
import org.hibernate.query.results.internal.DomainResultCreationStateImpl;
import org.hibernate.query.results.internal.ResultSetMappingSqlSelection;
import org.hibernate.query.results.internal.ResultsHelper;
import org.hibernate.query.results.internal.complete.CompleteResultBuilderBasicValued;
import org.hibernate.resource.beans.spi.ManagedBean;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;
import org.hibernate.type.descriptor.converter.internal.AttributeConverterBean;
import org.hibernate.type.descriptor.java.BasicJavaType;
import org.hibernate.type.descriptor.java.JavaType;

public class CompleteResultBuilderBasicValuedConverted<O, R>
implements CompleteResultBuilderBasicValued {
    private final String explicitColumnName;
    private final BasicValuedMapping underlyingMapping;
    private final AttributeConverterBean<O, R> valueConverter;

    public CompleteResultBuilderBasicValuedConverted(String explicitColumnName, ManagedBean<? extends AttributeConverter<O, R>> converterBean, JavaType<? extends AttributeConverter<O, R>> converterJtd, BasicJavaType<O> domainJavaType, BasicValuedMapping underlyingMapping) {
        this.explicitColumnName = explicitColumnName;
        this.underlyingMapping = underlyingMapping;
        JavaType relationalType = underlyingMapping.getJdbcMapping().getJavaTypeDescriptor();
        this.valueConverter = new AttributeConverterBean(converterBean, converterJtd, domainJavaType, relationalType);
    }

    @Override
    public Class<?> getJavaType() {
        return this.valueConverter.getDomainJavaType().getJavaTypeClass();
    }

    @Override
    public ResultBuilder cacheKeyInstance() {
        return this;
    }

    @Override
    public BasicResult<?> buildResult(JdbcValuesMetadata jdbcResultsMetadata, int resultPosition, DomainResultCreationState domainResultCreationState) {
        DomainResultCreationStateImpl creationStateImpl = ResultsHelper.impl(domainResultCreationState);
        String columnName = this.explicitColumnName != null ? this.explicitColumnName : jdbcResultsMetadata.resolveColumnName(creationStateImpl.getNumberOfProcessedSelections() + 1);
        return new BasicResult<O>(this.sqlSelection(jdbcResultsMetadata, resultPosition, creationStateImpl, columnName).getValuesArrayPosition(), columnName, this.valueConverter.getDomainJavaType(), this.valueConverter, null, false, false);
    }

    private SqlSelection sqlSelection(JdbcValuesMetadata jdbcResultsMetadata, int resultPosition, DomainResultCreationStateImpl creationStateImpl, String columnName) {
        SessionFactoryImplementor sessionFactory = creationStateImpl.getSessionFactory();
        return creationStateImpl.resolveSqlSelection(creationStateImpl.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(columnName), processingState -> {
            int jdbcPosition = this.explicitColumnName != null ? jdbcResultsMetadata.resolveColumnPosition(this.explicitColumnName) : resultPosition + 1;
            int valuesArrayPosition = ResultsHelper.jdbcPositionToValuesArrayPosition(jdbcPosition);
            return new ResultSetMappingSqlSelection(valuesArrayPosition, this.underlyingMapping);
        }), this.valueConverter.getRelationalJavaType(), null, sessionFactory.getTypeConfiguration());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompleteResultBuilderBasicValuedConverted that = (CompleteResultBuilderBasicValuedConverted)o;
        return Objects.equals(this.explicitColumnName, that.explicitColumnName) && this.underlyingMapping.equals(that.underlyingMapping) && this.valueConverter.equals(that.valueConverter);
    }

    public int hashCode() {
        int result = this.explicitColumnName != null ? this.explicitColumnName.hashCode() : 0;
        result = 31 * result + this.underlyingMapping.hashCode();
        result = 31 * result + this.valueConverter.hashCode();
        return result;
    }
}

