/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.property.access.spi;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Locale;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.Internal;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.property.access.internal.AbstractFieldSerialForm;
import org.hibernate.property.access.spi.Getter;
import org.hibernate.property.access.spi.PropertyAccessException;

@Internal
public class GetterFieldImpl
implements Getter {
    private final Class<?> containerClass;
    private final String propertyName;
    private final Field field;
    private final @Nullable Method getterMethod;

    public GetterFieldImpl(Class<?> containerClass, String propertyName, Field field) {
        this(containerClass, propertyName, field, ReflectHelper.findGetterMethodForFieldAccess(field, propertyName));
    }

    GetterFieldImpl(Class<?> containerClass, String propertyName, Field field, Method getterMethod) {
        this.containerClass = containerClass;
        this.propertyName = propertyName;
        this.field = field;
        this.getterMethod = getterMethod;
    }

    @Override
    public @Nullable Object get(Object owner) {
        try {
            return this.field.get(owner);
        }
        catch (Exception e) {
            throw new PropertyAccessException(String.format(Locale.ROOT, "Error accessing field [%s] by reflection for persistent property [%s#%s] : %s", this.field.toGenericString(), this.containerClass.getName(), this.propertyName, owner), e);
        }
    }

    @Override
    public @Nullable Object getForInsert(Object owner, Map<Object, Object> mergeMap, SharedSessionContractImplementor session) {
        return this.get(owner);
    }

    @Override
    public Class<?> getReturnTypeClass() {
        return this.field.getType();
    }

    @Override
    public Type getReturnType() {
        return this.field.getGenericType();
    }

    public Field getField() {
        return this.field;
    }

    @Override
    public Member getMember() {
        return this.getField();
    }

    @Override
    public @Nullable String getMethodName() {
        return this.getterMethod != null ? this.getterMethod.getName() : null;
    }

    @Override
    public @Nullable Method getMethod() {
        return this.getterMethod;
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerialForm(this.containerClass, this.propertyName, this.field);
    }

    private static class SerialForm
    extends AbstractFieldSerialForm
    implements Serializable {
        private final Class<?> containerClass;
        private final String propertyName;

        private SerialForm(Class<?> containerClass, String propertyName, Field field) {
            super(field);
            this.containerClass = containerClass;
            this.propertyName = propertyName;
        }

        private Object readResolve() {
            return new GetterFieldImpl(this.containerClass, this.propertyName, this.resolveField());
        }
    }
}

