/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.entity.mutation;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.Internal;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.batch.internal.BasicBatchKey;
import org.hibernate.engine.jdbc.batch.spi.BatchKey;
import org.hibernate.engine.jdbc.mutation.JdbcValueBindings;
import org.hibernate.engine.jdbc.mutation.MutationExecutor;
import org.hibernate.engine.jdbc.mutation.ParameterUsage;
import org.hibernate.engine.jdbc.mutation.TableInclusionChecker;
import org.hibernate.engine.jdbc.mutation.group.PreparedStatementDetails;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.generator.BeforeExecutionGenerator;
import org.hibernate.generator.EventType;
import org.hibernate.generator.Generator;
import org.hibernate.generator.OnExecutionGenerator;
import org.hibernate.generator.values.GeneratedValues;
import org.hibernate.generator.values.GeneratedValuesMutationDelegate;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.AttributeMappingsList;
import org.hibernate.metamodel.mapping.BasicEntityIdentifierMapping;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.mutation.AbstractMutationCoordinator;
import org.hibernate.persister.entity.mutation.EntityMutationTarget;
import org.hibernate.persister.entity.mutation.EntityTableMapping;
import org.hibernate.persister.entity.mutation.InsertCoordinator;
import org.hibernate.sql.model.MutationOperation;
import org.hibernate.sql.model.MutationOperationGroup;
import org.hibernate.sql.model.MutationType;
import org.hibernate.sql.model.TableMapping;
import org.hibernate.sql.model.ValuesAnalysis;
import org.hibernate.sql.model.ast.builder.MutationGroupBuilder;
import org.hibernate.sql.model.ast.builder.TableInsertBuilder;
import org.hibernate.sql.model.ast.builder.TableInsertBuilderStandard;
import org.hibernate.sql.model.ast.builder.TableMutationBuilder;
import org.hibernate.tuple.entity.EntityMetamodel;

@Internal
public class InsertCoordinatorStandard
extends AbstractMutationCoordinator
implements InsertCoordinator {
    private final MutationOperationGroup staticInsertGroup;
    private final BasicBatchKey batchKey;

    public InsertCoordinatorStandard(EntityPersister entityPersister, SessionFactoryImplementor factory) {
        super(entityPersister, factory);
        this.batchKey = entityPersister.isIdentifierAssignedByInsert() || entityPersister.hasInsertGeneratedProperties() ? null : new BasicBatchKey(entityPersister.getEntityName() + "#INSERT");
        this.staticInsertGroup = entityPersister.getEntityMetamodel().isDynamicInsert() ? null : this.generateStaticOperationGroup();
    }

    @Override
    public MutationOperationGroup getStaticMutationOperationGroup() {
        return this.staticInsertGroup;
    }

    @Override
    protected BatchKey getBatchKey() {
        return this.batchKey;
    }

    @Override
    public @Nullable GeneratedValues insert(Object entity, Object[] values, SharedSessionContractImplementor session) {
        return this.coordinateInsert(null, values, entity, session);
    }

    @Override
    public @Nullable GeneratedValues insert(Object entity, Object id, Object[] values, SharedSessionContractImplementor session) {
        return this.coordinateInsert(id, values, entity, session);
    }

    public GeneratedValues coordinateInsert(Object id, Object[] values, Object entity, SharedSessionContractImplementor session) {
        boolean forceIdentifierBinding;
        boolean needsDynamicInsert = this.preInsertInMemoryValueGeneration(values, entity, session);
        EntityPersister persister = this.entityPersister();
        boolean bl = forceIdentifierBinding = persister.getGenerator().generatedOnExecution() && id != null;
        if (persister.getEntityMetamodel().isDynamicInsert() || needsDynamicInsert || forceIdentifierBinding) {
            return this.doDynamicInserts(id, values, entity, session, forceIdentifierBinding);
        }
        return this.doStaticInserts(id, values, entity, session);
    }

    protected boolean preInsertInMemoryValueGeneration(Object[] values, Object entity, SharedSessionContractImplementor session) {
        EntityPersister persister = this.entityPersister();
        EntityMetamodel entityMetamodel = persister.getEntityMetamodel();
        boolean foundStateDependentGenerator = false;
        if (entityMetamodel.hasPreInsertGeneratedValues()) {
            Generator[] generators = entityMetamodel.getGenerators();
            for (int i = 0; i < generators.length; ++i) {
                Generator generator = generators[i];
                if (generator == null || !generator.generatesOnInsert() || !generator.generatedBeforeExecution(entity, session)) continue;
                values[i] = ((BeforeExecutionGenerator)generator).generate(session, entity, values[i], EventType.INSERT);
                persister.setPropertyValue(entity, i, values[i]);
                foundStateDependentGenerator = foundStateDependentGenerator || generator.generatedOnExecution();
            }
        }
        return foundStateDependentGenerator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GeneratedValues doStaticInserts(Object id, Object[] values, Object object, SharedSessionContractImplementor session) {
        InsertValuesAnalysis insertValuesAnalysis = new InsertValuesAnalysis(this.entityPersister(), values);
        TableInclusionChecker tableInclusionChecker = InsertCoordinatorStandard.getTableInclusionChecker(insertValuesAnalysis);
        MutationExecutor mutationExecutor = this.executor(session, this.staticInsertGroup, false);
        this.decomposeForInsert(mutationExecutor, id, values, this.staticInsertGroup, this.entityPersister().getPropertyInsertability(), tableInclusionChecker, session);
        try {
            GeneratedValues generatedValues = mutationExecutor.execute(object, insertValuesAnalysis, tableInclusionChecker, InsertCoordinatorStandard::verifyOutcome, session);
            return generatedValues;
        }
        finally {
            mutationExecutor.release();
        }
    }

    protected void decomposeForInsert(MutationExecutor mutationExecutor, Object id, Object[] values, MutationOperationGroup mutationGroup, boolean[] propertyInclusions, TableInclusionChecker tableInclusionChecker, SharedSessionContractImplementor session) {
        EntityTableMapping tableDetails;
        int position;
        JdbcValueBindings jdbcValueBindings = mutationExecutor.getJdbcValueBindings();
        AttributeMappingsList attributeMappings = this.entityPersister().getAttributeMappings();
        for (position = 0; position < mutationGroup.getNumberOfOperations(); ++position) {
            MutationOperation operation = mutationGroup.getOperation(position);
            tableDetails = (EntityTableMapping)operation.getTableDetails();
            if (!tableInclusionChecker.include(tableDetails)) continue;
            int[] attributeIndexes = tableDetails.getAttributeIndexes();
            for (int i = 0; i < attributeIndexes.length; ++i) {
                int attributeIndex = attributeIndexes[i];
                if (!propertyInclusions[attributeIndex]) continue;
                AttributeMapping mapping = attributeMappings.get(attributeIndex);
                this.decomposeAttribute(values[attributeIndex], session, jdbcValueBindings, mapping);
            }
        }
        if (id == null) {
            assert (this.entityPersister().getInsertDelegate() != null);
        } else {
            for (position = 0; position < mutationGroup.getNumberOfOperations(); ++position) {
                MutationOperation jdbcOperation = mutationGroup.getOperation(position);
                tableDetails = (EntityTableMapping)jdbcOperation.getTableDetails();
                this.breakDownJdbcValue(id, session, jdbcValueBindings, tableDetails);
            }
        }
    }

    protected void breakDownJdbcValue(Object id, SharedSessionContractImplementor session, JdbcValueBindings jdbcValueBindings, EntityTableMapping tableDetails) {
        String tableName = tableDetails.getTableName();
        tableDetails.getKeyMapping().breakDownKeyJdbcValues(id, (jdbcValue, columnMapping) -> jdbcValueBindings.bindValue(jdbcValue, tableName, columnMapping.getColumnName(), ParameterUsage.SET), session);
    }

    protected void decomposeAttribute(Object value, SharedSessionContractImplementor session, JdbcValueBindings jdbcValueBindings, AttributeMapping mapping) {
        if (!(mapping instanceof PluralAttributeMapping)) {
            mapping.decompose(value, 0, jdbcValueBindings, null, (valueIndex, bindings, noop, jdbcValue, selectableMapping) -> {
                if (selectableMapping.isInsertable()) {
                    bindings.bindValue(jdbcValue, this.entityPersister().physicalTableNameForMutation(selectableMapping), selectableMapping.getSelectionExpression(), ParameterUsage.SET);
                }
            }, session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GeneratedValues doDynamicInserts(Object id, Object[] values, Object object, SharedSessionContractImplementor session, boolean forceIdentifierBinding) {
        boolean[] insertability = this.getPropertiesToInsert(values);
        MutationOperationGroup insertGroup = this.generateDynamicInsertSqlGroup(insertability, object, session, forceIdentifierBinding);
        MutationExecutor mutationExecutor = this.executor(session, insertGroup, true);
        InsertValuesAnalysis insertValuesAnalysis = new InsertValuesAnalysis(this.entityPersister(), values);
        TableInclusionChecker tableInclusionChecker = InsertCoordinatorStandard.getTableInclusionChecker(insertValuesAnalysis);
        this.decomposeForInsert(mutationExecutor, id, values, insertGroup, insertability, tableInclusionChecker, session);
        try {
            GeneratedValues generatedValues = mutationExecutor.execute(object, insertValuesAnalysis, tableInclusionChecker, InsertCoordinatorStandard::verifyOutcome, session);
            return generatedValues;
        }
        finally {
            mutationExecutor.release();
        }
    }

    private static boolean verifyOutcome(PreparedStatementDetails statementDetails, int affectedRowCount, int batchPosition) throws SQLException {
        statementDetails.getExpectation().verifyOutcome(affectedRowCount, statementDetails.getStatement(), batchPosition, statementDetails.getSqlString());
        return true;
    }

    private MutationExecutor executor(SharedSessionContractImplementor session, MutationOperationGroup group, boolean dynamicUpdate) {
        return this.mutationExecutorService.createExecutor(this.resolveBatchKeyAccess(dynamicUpdate, session), group, session);
    }

    protected static TableInclusionChecker getTableInclusionChecker(InsertValuesAnalysis insertValuesAnalysis) {
        return tableMapping -> !tableMapping.isOptional() || insertValuesAnalysis.hasNonNullBindings(tableMapping);
    }

    public boolean[] getPropertiesToInsert(Object[] fields) {
        boolean[] notNull = new boolean[fields.length];
        boolean[] insertable = this.entityPersister().getPropertyInsertability();
        for (int i = 0; i < fields.length; ++i) {
            notNull[i] = insertable[i] && fields[i] != null;
        }
        return notNull;
    }

    protected MutationOperationGroup generateDynamicInsertSqlGroup(boolean[] insertable, Object object, SharedSessionContractImplementor session, boolean forceIdentifierBinding) {
        MutationGroupBuilder insertGroupBuilder = new MutationGroupBuilder(MutationType.INSERT, this.entityPersister());
        this.entityPersister().forEachMutableTable(tableMapping -> insertGroupBuilder.addTableDetailsBuilder(this.createTableInsertBuilder((EntityTableMapping)tableMapping, forceIdentifierBinding)));
        this.applyTableInsertDetails(insertGroupBuilder, insertable, object, session, forceIdentifierBinding);
        return this.createOperationGroup(null, insertGroupBuilder.buildMutationGroup());
    }

    public MutationOperationGroup generateStaticOperationGroup() {
        MutationGroupBuilder insertGroupBuilder = new MutationGroupBuilder(MutationType.INSERT, this.entityPersister());
        this.entityPersister().forEachMutableTable(tableMapping -> insertGroupBuilder.addTableDetailsBuilder(this.createTableInsertBuilder((EntityTableMapping)tableMapping, false)));
        this.applyTableInsertDetails(insertGroupBuilder, this.entityPersister().getPropertyInsertability(), null, null, false);
        return this.createOperationGroup(null, insertGroupBuilder.buildMutationGroup());
    }

    private TableMutationBuilder<?> createTableInsertBuilder(EntityTableMapping tableMapping, boolean forceIdentifierBinding) {
        GeneratedValuesMutationDelegate delegate = this.entityPersister().getInsertDelegate();
        if (tableMapping.isIdentifierTable() && delegate != null && !forceIdentifierBinding) {
            return delegate.createTableMutationBuilder(tableMapping.getInsertExpectation(), this.factory());
        }
        return new TableInsertBuilderStandard(this.entityPersister(), tableMapping, this.factory());
    }

    private void applyTableInsertDetails(MutationGroupBuilder insertGroupBuilder, boolean[] attributeInclusions, Object object, SharedSessionContractImplementor session, boolean forceIdentifierBinding) {
        AttributeMappingsList attributeMappings = this.entityPersister().getAttributeMappings();
        insertGroupBuilder.forEachTableMutationBuilder(builder -> {
            EntityTableMapping tableMapping = (EntityTableMapping)builder.getMutatingTable().getTableMapping();
            assert (!tableMapping.isInverse());
            int[] attributeIndexes = tableMapping.getAttributeIndexes();
            for (int i = 0; i < attributeIndexes.length; ++i) {
                int attributeIndex = attributeIndexes[i];
                AttributeMapping attributeMapping = attributeMappings.get(attributeIndex);
                if (attributeInclusions[attributeIndex]) {
                    attributeMapping.forEachInsertable(insertGroupBuilder);
                    continue;
                }
                Generator generator = attributeMapping.getGenerator();
                if (!InsertCoordinatorStandard.isValueGenerated(generator)) continue;
                if (session != null && generator.generatedBeforeExecution(object, session)) {
                    attributeInclusions[attributeIndex] = true;
                    attributeMapping.forEachInsertable(insertGroupBuilder);
                    continue;
                }
                if (!InsertCoordinatorStandard.isValueGenerationInSql(generator, this.factory.getJdbcServices().getDialect())) continue;
                this.handleValueGeneration(attributeMapping, insertGroupBuilder, (OnExecutionGenerator)generator);
            }
        });
        this.entityPersister().addDiscriminatorToInsertGroup(insertGroupBuilder);
        this.entityPersister().addSoftDeleteToInsertGroup(insertGroupBuilder);
        insertGroupBuilder.forEachTableMutationBuilder(tableMutationBuilder -> {
            TableInsertBuilder tableInsertBuilder = (TableInsertBuilder)tableMutationBuilder;
            EntityTableMapping tableMapping = (EntityTableMapping)tableInsertBuilder.getMutatingTable().getTableMapping();
            if (tableMapping.isIdentifierTable() && this.entityPersister().isIdentifierAssignedByInsert() && !forceIdentifierBinding) {
                assert (this.entityPersister().getInsertDelegate() != null);
                OnExecutionGenerator generator = (OnExecutionGenerator)this.entityPersister().getGenerator();
                if (generator.referenceColumnsInSql(this.dialect)) {
                    BasicEntityIdentifierMapping identifierMapping = (BasicEntityIdentifierMapping)this.entityPersister().getIdentifierMapping();
                    String[] columnValues = generator.getReferencedColumnValues(this.dialect);
                    if (columnValues != null) {
                        tableMapping.getKeyMapping().forEachKeyColumn((i, column) -> tableInsertBuilder.addKeyColumn(column.getColumnName(), columnValues[i], identifierMapping.getJdbcMapping()));
                    }
                }
            } else {
                tableMapping.getKeyMapping().forEachKeyColumn(tableInsertBuilder::addKeyColumn);
            }
        });
    }

    private static boolean isValueGenerated(Generator generator) {
        return generator != null && generator.generatesOnInsert() && generator.generatedOnExecution();
    }

    private static boolean isValueGenerationInSql(Generator generator, Dialect dialect) {
        assert (InsertCoordinatorStandard.isValueGenerated(generator));
        return ((OnExecutionGenerator)generator).referenceColumnsInSql(dialect);
    }

    @Deprecated
    public BasicBatchKey getInsertBatchKey() {
        return this.batchKey;
    }

    public static class InsertValuesAnalysis
    implements ValuesAnalysis {
        private final List<TableMapping> tablesWithNonNullValues = new ArrayList<TableMapping>();

        public InsertValuesAnalysis(EntityMutationTarget mutationTarget, Object[] values) {
            mutationTarget.forEachMutableTable(tableMapping -> {
                int[] tableAttributeIndexes = tableMapping.getAttributeIndexes();
                for (int i = 0; i < tableAttributeIndexes.length; ++i) {
                    if (values[tableAttributeIndexes[i]] == null) continue;
                    this.tablesWithNonNullValues.add((TableMapping)tableMapping);
                    break;
                }
            });
        }

        public boolean hasNonNullBindings(TableMapping tableMapping) {
            return this.tablesWithNonNullValues.contains(tableMapping);
        }
    }
}

