/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping;

import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.ValuedModelPart;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.type.descriptor.java.JavaTypedExpressible;

public interface CollectionPart
extends ValuedModelPart,
Fetchable,
JavaTypedExpressible {
    public Nature getNature();

    public PluralAttributeMapping getCollectionAttribute();

    @Override
    default public String getPartName() {
        return this.getNature().getName();
    }

    default public ModelPart getInclusionCheckPart() {
        return this;
    }

    public static enum Nature {
        ELEMENT,
        INDEX,
        ID;


        public String getName() {
            return switch (this.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> "{element}";
                case 1 -> "{index}";
                case 2 -> "{collection-id}";
            };
        }

        public static Nature fromNameExact(String name) {
            return switch (name) {
                case "{element}" -> ELEMENT;
                case "{index}" -> INDEX;
                case "{collection-id}" -> ID;
                default -> null;
            };
        }

        public static Nature fromName(String name) {
            if ("key".equals(name) || "{key}".equals(name) || "keys".equals(name) || "{keys}".equals(name) || "index".equals(name) || "{index}".equals(name) || "indices".equals(name) || "{indices}".equals(name) || "$index$".equals(name)) {
                return INDEX;
            }
            if ("element".equals(name) || "{element}".equals(name) || "elements".equals(name) || "{elements}".equals(name) || "value".equals(name) || "{value}".equals(name) || "values".equals(name) || "{values}".equals(name) || "$element$".equals(name)) {
                return ELEMENT;
            }
            if (ID.getName().equals(name)) {
                return ID;
            }
            return null;
        }
    }
}

