/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.util.Arrays;
import java.util.List;
import org.hibernate.Internal;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Constraint;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.UniqueKey;

public class PrimaryKey
extends Constraint {
    private UniqueKey orderingUniqueKey = null;
    private int[] originalOrder;

    public PrimaryKey(Table table) {
        super(table);
    }

    @Deprecated(since="7")
    public PrimaryKey() {
    }

    @Override
    public void addColumn(Column column) {
        for (Column next : this.getTable().getColumns()) {
            if (!next.getCanonicalName().equals(column.getCanonicalName())) continue;
            next.setNullable(false);
        }
        super.addColumn(column);
    }

    @Override
    public String getExportIdentifier() {
        return StringHelper.qualify(this.getTable().getExportIdentifier(), "PK-" + this.getName());
    }

    public List<Column> getColumnsInOriginalOrder() {
        List<Column> columns = this.getColumns();
        if (this.originalOrder == null) {
            return columns;
        }
        Column[] columnsInOriginalOrder = new Column[columns.size()];
        for (int i = 0; i < columnsInOriginalOrder.length; ++i) {
            columnsInOriginalOrder[this.originalOrder[i]] = columns.get(i);
        }
        return Arrays.asList(columnsInOriginalOrder);
    }

    public void setOrderingUniqueKey(UniqueKey uniqueKey) {
        this.orderingUniqueKey = uniqueKey;
    }

    public UniqueKey getOrderingUniqueKey() {
        return this.orderingUniqueKey;
    }

    @Internal
    public void reorderColumns(List<Column> reorderedColumns) {
        List<Column> columns = this.getColumns();
        if (this.originalOrder != null) {
            assert (columns.equals(reorderedColumns));
            return;
        }
        assert (columns.size() == reorderedColumns.size() && columns.containsAll(reorderedColumns));
        this.originalOrder = new int[columns.size()];
        UniqueKey orderingUniqueKey = this.getOrderingUniqueKey();
        List<Column> newColumns = orderingUniqueKey != null ? orderingUniqueKey.getColumns() : reorderedColumns;
        for (int i = 0; i < newColumns.size(); ++i) {
            Column reorderedColumn = newColumns.get(i);
            this.originalOrder[i] = columns.indexOf(reorderedColumn);
        }
        columns.clear();
        columns.addAll(newColumns);
    }

    @Internal
    public int[] getOriginalOrder() {
        return this.originalOrder;
    }
}

