/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.lock.internal;

import jakarta.persistence.Timeout;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.RowLockStrategy;
import org.hibernate.dialect.lock.spi.ConnectionLockTimeoutStrategy;
import org.hibernate.dialect.lock.spi.LockTimeoutType;
import org.hibernate.dialect.lock.spi.LockingSupport;
import org.hibernate.dialect.lock.spi.OuterJoinLockingType;

public class OracleLockingSupport
implements LockingSupport,
LockingSupport.Metadata {
    public static final OracleLockingSupport ORACLE_LOCKING_SUPPORT = new OracleLockingSupport();
    private final boolean supportsNoWait;
    private final boolean supportsSkipLocked;

    public OracleLockingSupport() {
        this.supportsNoWait = true;
        this.supportsSkipLocked = true;
    }

    public OracleLockingSupport(DatabaseVersion version) {
        this.supportsNoWait = version.isSameOrAfter(9);
        this.supportsSkipLocked = version.isSameOrAfter(10);
    }

    @Override
    public LockingSupport.Metadata getMetadata() {
        return this;
    }

    @Override
    public LockTimeoutType getLockTimeoutType(Timeout timeout) {
        return switch (timeout.milliseconds()) {
            case 0 -> {
                if (this.supportsNoWait) {
                    yield LockTimeoutType.QUERY;
                }
                yield LockTimeoutType.NONE;
            }
            case -2 -> {
                if (this.supportsSkipLocked) {
                    yield LockTimeoutType.QUERY;
                }
                yield LockTimeoutType.NONE;
            }
            case -1 -> LockTimeoutType.NONE;
            default -> LockTimeoutType.QUERY;
        };
    }

    @Override
    public RowLockStrategy getWriteRowLockStrategy() {
        return RowLockStrategy.COLUMN;
    }

    @Override
    public OuterJoinLockingType getOuterJoinLockingType() {
        return OuterJoinLockingType.UNSUPPORTED;
    }

    @Override
    public ConnectionLockTimeoutStrategy getConnectionLockTimeoutStrategy() {
        return ConnectionLockTimeoutStrategy.NONE;
    }
}

