/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.lock.internal;

import jakarta.persistence.Timeout;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.lock.internal.MySQLLockingSupport;
import org.hibernate.dialect.lock.spi.ConnectionLockTimeoutStrategy;
import org.hibernate.dialect.lock.spi.LockTimeoutType;
import org.hibernate.dialect.lock.spi.LockingSupport;
import org.hibernate.dialect.lock.spi.OuterJoinLockingType;

public class MariaDBLockingSupport
implements LockingSupport,
LockingSupport.Metadata {
    private final LockTimeoutType skipLockedType;
    private final LockTimeoutType noWaitType;
    private final LockTimeoutType waitType;

    public MariaDBLockingSupport(boolean supportsSkipLocked, boolean supportsNoWait, boolean supportsWait) {
        this.skipLockedType = supportsSkipLocked ? LockTimeoutType.QUERY : LockTimeoutType.NONE;
        this.noWaitType = supportsNoWait ? LockTimeoutType.QUERY : LockTimeoutType.NONE;
        this.waitType = LockTimeoutType.NONE;
    }

    public MariaDBLockingSupport(boolean supportsSkipLocked, boolean supportsWait) {
        this(supportsSkipLocked, supportsWait, supportsWait);
    }

    public MariaDBLockingSupport(DatabaseVersion databaseVersion) {
        this(databaseVersion.isSameOrAfter(10, 6), true, true);
    }

    @Override
    public LockingSupport.Metadata getMetadata() {
        return this;
    }

    @Override
    public LockTimeoutType getLockTimeoutType(Timeout timeout) {
        return switch (timeout.milliseconds()) {
            case 0 -> this.noWaitType;
            case -2 -> this.skipLockedType;
            case -1 -> LockTimeoutType.NONE;
            default -> this.waitType;
        };
    }

    @Override
    public OuterJoinLockingType getOuterJoinLockingType() {
        return OuterJoinLockingType.FULL;
    }

    @Override
    public ConnectionLockTimeoutStrategy getConnectionLockTimeoutStrategy() {
        return MySQLLockingSupport.MYSQL_CONN_LOCK_TIMEOUT_STRATEGY;
    }
}

