/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.internal.bytebuddy;

import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.scaffold.subclass.ConstructorStrategy;
import net.bytebuddy.implementation.Implementation;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.bytecode.internal.bytebuddy.ByteBuddyState;
import org.hibernate.bytecode.internal.bytebuddy.PassThroughInterceptor;
import org.hibernate.bytecode.spi.BasicProxyFactory;
import org.hibernate.engine.spi.PrimeAmongSecondarySupertypes;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.proxy.ProxyConfiguration;

public class BasicProxyFactoryImpl
implements BasicProxyFactory {
    private static final Class[] NO_INTERFACES = ArrayHelper.EMPTY_CLASS_ARRAY;
    private static final String PROXY_NAMING_SUFFIX = "HibernateBasicProxy";
    private final Class proxyClass;
    private final Constructor proxyClassConstructor;

    public BasicProxyFactoryImpl(Class superClass, Class interfaceClass, ByteBuddyState byteBuddyState) {
        if (superClass == null && interfaceClass == null) {
            throw new AssertionFailure("attempting to build proxy without any superclass or interfaces");
        }
        if (superClass != null && interfaceClass != null) {
            throw new AssertionFailure("Ambiguous call: we assume invocation with EITHER a superClass OR an interfaceClass");
        }
        Class superClassOrMainInterface = superClass != null ? superClass : interfaceClass;
        ByteBuddyState.ProxyDefinitionHelpers helpers = byteBuddyState.getProxyDefinitionHelpers();
        String proxyClassName = superClassOrMainInterface.getName() + "$HibernateBasicProxy";
        this.proxyClass = byteBuddyState.loadBasicProxy(superClassOrMainInterface, proxyClassName, (byteBuddy, namingStrategy) -> {
            Type[] typeArray;
            DynamicType.Builder builder = byteBuddy.with(namingStrategy).subclass(superClass == null ? Object.class : superClass, (ConstructorStrategy)ConstructorStrategy.Default.DEFAULT_CONSTRUCTOR);
            if (interfaceClass == null) {
                typeArray = NO_INTERFACES;
            } else {
                Class[] classArray = new Class[1];
                typeArray = classArray;
                classArray[0] = interfaceClass;
            }
            return helpers.appendIgnoreAlsoAtEnd((DynamicType.Builder<?>)builder.implement(typeArray).defineField("$$_hibernate_interceptor", ProxyConfiguration.Interceptor.class, new ModifierContributor.ForField[]{Visibility.PRIVATE}).method(byteBuddyState.getProxyDefinitionHelpers().getVirtualNotFinalizerFilter()).intercept((Implementation)byteBuddyState.getProxyDefinitionHelpers().getDelegateToInterceptorDispatcherMethodDelegation()).implement(new Type[]{ProxyConfiguration.class}).intercept((Implementation)byteBuddyState.getProxyDefinitionHelpers().getInterceptorFieldAccessor()));
        });
        try {
            this.proxyClassConstructor = this.proxyClass.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionFailure("Could not access default constructor from newly generated basic proxy");
        }
    }

    @Override
    public Object getProxy() {
        PrimeAmongSecondarySupertypes instance;
        try {
            instance = (PrimeAmongSecondarySupertypes)this.proxyClassConstructor.newInstance(new Object[0]);
        }
        catch (Throwable t) {
            throw new HibernateException("Unable to instantiate proxy instance", t);
        }
        ProxyConfiguration proxyConfiguration = instance.asProxyConfiguration();
        if (proxyConfiguration == null) {
            throw new HibernateException("Produced proxy does not correctly implement ProxyConfiguration");
        }
        PassThroughInterceptor interceptor = new PassThroughInterceptor(this.proxyClass.getName());
        proxyConfiguration.$$_hibernate_set_interceptor(interceptor);
        return instance;
    }

    public boolean isInstance(Object object) {
        return this.proxyClass.isInstance(object);
    }
}

