/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.jaxb.hbm.transform;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.hibernate.boot.jaxb.hbm.spi.EntityInfo;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmDiscriminatorSubclassEntityType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmHibernateMapping;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmJoinedSubclassEntityType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmRootEntityType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmTypeDefinitionType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmUnionSubclassEntityType;
import org.hibernate.boot.jaxb.hbm.transform.TransformationHelper;
import org.hibernate.boot.jaxb.hbm.transform.TransformationState;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityMappingsImpl;
import org.hibernate.boot.jaxb.spi.Binding;
import org.hibernate.internal.util.collections.CollectionHelper;

public class XmlPreprocessor {
    public static List<Binding<JaxbEntityMappingsImpl>> preprocessHbmXml(List<Binding<JaxbHbmHibernateMapping>> hbmXmlBindings, TransformationState transformationState) {
        ArrayList<Binding<JaxbEntityMappingsImpl>> mappingBindings = CollectionHelper.arrayList(hbmXmlBindings.size());
        hbmXmlBindings.forEach(hbmXmlBinding -> XmlPreprocessor.preProcessHbmXml(hbmXmlBinding, mappingBindings, transformationState));
        return mappingBindings;
    }

    private static void preProcessHbmXml(Binding<JaxbHbmHibernateMapping> hbmXmlBinding, List<Binding<JaxbEntityMappingsImpl>> mappingBindings, TransformationState transformationState) {
        JaxbHbmHibernateMapping hbmRoot = hbmXmlBinding.getRoot();
        JaxbEntityMappingsImpl mappingRoot = new JaxbEntityMappingsImpl();
        transformationState.getJaxbRootMap().put(hbmRoot, mappingRoot);
        mappingRoot.setDescription(String.format(Locale.ROOT, "Generated by Hibernate HbmXmlTransformer from %s (%s)", new Object[]{hbmXmlBinding.getOrigin().getName(), hbmXmlBinding.getOrigin().getType()}));
        mappingBindings.add(new Binding<JaxbEntityMappingsImpl>(mappingRoot, hbmXmlBinding.getOrigin()));
        hbmRoot.getTypedef().forEach(hbmTypeDef -> transformationState.getTypeDefMap().put(hbmTypeDef.getName(), (JaxbHbmTypeDefinitionType)hbmTypeDef));
        hbmRoot.getClazz().forEach(hbmRootEntity -> XmlPreprocessor.preProcessRooEntity(hbmRootEntity, hbmRoot, mappingRoot, transformationState));
        hbmRoot.getSubclass().forEach(hbmSubclass -> XmlPreprocessor.preProcessSubclass(hbmSubclass, hbmRoot, mappingRoot, transformationState));
        hbmRoot.getJoinedSubclass().forEach(hbmSubclass -> XmlPreprocessor.preProcessJoinedSubclass(hbmSubclass, hbmRoot, mappingRoot, transformationState));
        hbmRoot.getUnionSubclass().forEach(hbmSubclass -> XmlPreprocessor.preProcessUnionSubclass(hbmSubclass, hbmRoot, mappingRoot, transformationState));
    }

    private static void preProcessRooEntity(JaxbHbmRootEntityType hbmRootEntity, JaxbHbmHibernateMapping hbmRoot, JaxbEntityMappingsImpl mappingRoot, TransformationState transformationState) {
        JaxbEntityImpl mappingEntity = new JaxbEntityImpl();
        mappingRoot.getEntities().add(mappingEntity);
        XmlPreprocessor.commonEntityPreprocessing(hbmRootEntity, hbmRoot, mappingRoot, transformationState, mappingEntity);
        hbmRootEntity.getSubclass().forEach(hbmSubclass -> XmlPreprocessor.preProcessSubclass(hbmSubclass, hbmRoot, mappingRoot, transformationState));
        hbmRootEntity.getJoinedSubclass().forEach(hbmSubclass -> XmlPreprocessor.preProcessJoinedSubclass(hbmSubclass, hbmRoot, mappingRoot, transformationState));
        hbmRootEntity.getUnionSubclass().forEach(hbmSubclass -> XmlPreprocessor.preProcessUnionSubclass(hbmSubclass, hbmRoot, mappingRoot, transformationState));
    }

    private static void commonEntityPreprocessing(EntityInfo hbmEntity, JaxbHbmHibernateMapping hbmRoot, JaxbEntityMappingsImpl mappingRoot, TransformationState transformationState, JaxbEntityImpl mappingEntity) {
        TransformationHelper.transfer(hbmEntity::getEntityName, mappingEntity::setName);
        TransformationHelper.transfer(hbmEntity::getName, mappingEntity::setClazz);
        String entityName = TransformationHelper.determineEntityName(hbmEntity, hbmRoot);
        transformationState.getEntityToHbmXmlMap().put(entityName, hbmRoot);
        transformationState.getEntityToMappingXmlMap().put(entityName, mappingRoot);
        transformationState.getHbmEntityByName().put(entityName, hbmEntity);
        transformationState.getMappingEntityByName().put(entityName, mappingEntity);
    }

    private static void preProcessSubclass(JaxbHbmDiscriminatorSubclassEntityType hbmSubclass, JaxbHbmHibernateMapping hbmRoot, JaxbEntityMappingsImpl mappingRoot, TransformationState transformationState) {
        JaxbEntityImpl mappingEntity = new JaxbEntityImpl();
        mappingRoot.getEntities().add(mappingEntity);
        XmlPreprocessor.commonEntityPreprocessing(hbmSubclass, hbmRoot, mappingRoot, transformationState, mappingEntity);
        hbmSubclass.getSubclass().forEach(hbmSubclassSubclass -> XmlPreprocessor.preProcessSubclass(hbmSubclassSubclass, hbmRoot, mappingRoot, transformationState));
    }

    private static void preProcessJoinedSubclass(JaxbHbmJoinedSubclassEntityType hbmSubclass, JaxbHbmHibernateMapping hbmRoot, JaxbEntityMappingsImpl mappingRoot, TransformationState transformationState) {
        JaxbEntityImpl mappingEntity = new JaxbEntityImpl();
        mappingRoot.getEntities().add(mappingEntity);
        XmlPreprocessor.commonEntityPreprocessing(hbmSubclass, hbmRoot, mappingRoot, transformationState, mappingEntity);
        hbmSubclass.getJoinedSubclass().forEach(hbmSubclassSubclass -> XmlPreprocessor.preProcessJoinedSubclass(hbmSubclassSubclass, hbmRoot, mappingRoot, transformationState));
    }

    private static void preProcessUnionSubclass(JaxbHbmUnionSubclassEntityType hbmSubclass, JaxbHbmHibernateMapping hbmRoot, JaxbEntityMappingsImpl mappingRoot, TransformationState transformationState) {
        JaxbEntityImpl mappingEntity = new JaxbEntityImpl();
        mappingRoot.getEntities().add(mappingEntity);
        XmlPreprocessor.commonEntityPreprocessing(hbmSubclass, hbmRoot, mappingRoot, transformationState, mappingEntity);
        hbmSubclass.getUnionSubclass().forEach(hbmSubclassSubclass -> XmlPreprocessor.preProcessUnionSubclass(hbmSubclassSubclass, hbmRoot, mappingRoot, transformationState));
    }
}

