/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate;

import jakarta.persistence.EntityGraph;
import jakarta.persistence.PessimisticLockScope;
import jakarta.persistence.Timeout;
import java.util.List;
import org.hibernate.CacheMode;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.graph.GraphSemantic;

public interface NaturalIdMultiLoadAccess<T> {
    default public NaturalIdMultiLoadAccess<T> with(LockMode lockMode) {
        return this.with(lockMode, PessimisticLockScope.NORMAL);
    }

    public NaturalIdMultiLoadAccess<T> with(LockMode var1, PessimisticLockScope var2);

    public NaturalIdMultiLoadAccess<T> with(Timeout var1);

    @Deprecated(since="7.0", forRemoval=true)
    public NaturalIdMultiLoadAccess<T> with(LockOptions var1);

    public NaturalIdMultiLoadAccess<T> with(CacheMode var1);

    default public NaturalIdMultiLoadAccess<T> withFetchGraph(EntityGraph<T> graph) {
        return this.with(graph, GraphSemantic.FETCH);
    }

    default public NaturalIdMultiLoadAccess<T> withLoadGraph(EntityGraph<T> graph) {
        return this.with(graph, GraphSemantic.LOAD);
    }

    @Deprecated(since="6.3")
    default public NaturalIdMultiLoadAccess<T> with(EntityGraph<T> graph) {
        return this.with(graph, GraphSemantic.LOAD);
    }

    public NaturalIdMultiLoadAccess<T> with(EntityGraph<T> var1, GraphSemantic var2);

    public NaturalIdMultiLoadAccess<T> withBatchSize(int var1);

    public NaturalIdMultiLoadAccess<T> enableReturnOfDeletedEntities(boolean var1);

    public NaturalIdMultiLoadAccess<T> enableOrderedReturn(boolean var1);

    public List<T> multiLoad(Object ... var1);

    public List<T> multiLoad(List<?> var1);
}

