/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.LocalVar;
import io.quarkus.gizmo2.creator.BlockCreator;
import io.quarkus.gizmo2.creator.TryCreator;
import io.quarkus.gizmo2.impl.BlockCreatorImpl;
import io.quarkus.gizmo2.impl.TryCatch;
import io.quarkus.gizmo2.impl.TryFinally;
import io.quarkus.gizmo2.impl.Util;
import java.lang.constant.ClassDesc;
import java.util.Iterator;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public final class TryCreatorImpl
implements TryCreator {
    private static final int ST_INITIAL = 0;
    private static final int ST_BODY = 1;
    private static final int ST_CATCH = 2;
    private static final int ST_FINALLY = 3;
    private static final int ST_DONE = 4;
    private final BlockCreatorImpl body;
    private TryCatch tryCatch;
    private TryFinally tryFinally;
    private int state = 0;

    public TryCreatorImpl(BlockCreatorImpl parent) {
        this.body = new BlockCreatorImpl(parent);
    }

    private void advanceToState(int newState) {
        if (this.state > newState) {
            throw new IllegalStateException("Wrong method call order: body() must come first, then arbitrarily many catch_(), then at most one finally_()");
        }
        this.state = newState;
    }

    @Override
    public void body(Consumer<BlockCreator> builder) {
        this.advanceToState(1);
        this.body.accept(builder);
        this.advanceToState(2);
    }

    @Override
    public void catch_(Class<? extends Throwable> type, String caughtName, BiConsumer<BlockCreator, ? super LocalVar> builder) {
        this.catch_(Util.classDesc(type), caughtName, builder);
    }

    @Override
    public void catch_(Set<Class<? extends Throwable>> types, String caughtName, BiConsumer<BlockCreator, ? super LocalVar> builder) {
        if (types.isEmpty()) {
            return;
        }
        Iterator<Class<? extends Throwable>> iterator = types.iterator();
        assert (iterator.hasNext());
        Class<Throwable> type = iterator.next().asSubclass(Throwable.class);
        while (iterator.hasNext()) {
            type = this.findCommonSuper(type, iterator.next().asSubclass(Throwable.class));
        }
        this.catch_(Util.classDesc(type), caughtName, builder);
    }

    private Class<? extends Throwable> findCommonSuper(Class<? extends Throwable> a, Class<? extends Throwable> b) {
        if (a.isAssignableFrom(b)) {
            return a;
        }
        if (b.isAssignableFrom(a)) {
            return b;
        }
        Class<? extends Throwable> superA = a.getSuperclass();
        if (superA == Throwable.class) {
            return Throwable.class;
        }
        return this.findCommonSuper(superA.asSubclass(Throwable.class), b);
    }

    @Override
    public void catch_(ClassDesc type, String caughtName, BiConsumer<BlockCreator, ? super LocalVar> builder) {
        this.catch_(type, Set.of(type), caughtName, builder);
    }

    @Override
    public void catch_(ClassDesc superType, Set<ClassDesc> types, String caughtName, BiConsumer<BlockCreator, ? super LocalVar> builder) {
        this.advanceToState(2);
        if (this.tryCatch == null) {
            this.tryCatch = new TryCatch(this.body);
        }
        this.tryCatch.addCatch(superType, types, caughtName).accept((? super BlockCreatorImpl b0, Expr e) -> builder.accept((BlockCreator)b0, b0.localVar(caughtName, (Expr)e)));
    }

    @Override
    public void finally_(Consumer<BlockCreator> builder) {
        this.advanceToState(3);
        if (this.tryFinally != null) {
            throw new IllegalStateException("Only one finally block is allowed");
        }
        if (this.tryCatch == null) {
            this.tryFinally = new TryFinally(this.body, builder);
        } else {
            BlockCreatorImpl finallyBody = new BlockCreatorImpl(this.body.parent());
            this.body.tryFinally = this.tryFinally = new TryFinally(finallyBody, builder);
            this.tryFinally.body().addItem(this.tryCatch);
        }
    }

    void addTo(BlockCreatorImpl bci) {
        if (this.tryFinally != null) {
            bci.addItem(this.tryFinally);
        } else if (this.tryCatch != null) {
            bci.addItem(this.tryCatch);
        }
    }

    public void accept(Consumer<? super TryCreatorImpl> handler) {
        this.advanceToState(0);
        handler.accept(this);
        this.advanceToState(4);
    }
}

