/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.github.dmlloyd.classfile.CodeBuilder;
import io.github.dmlloyd.classfile.TypeKind;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.impl.BlockCreatorImpl;
import io.quarkus.gizmo2.impl.Item;
import io.quarkus.gizmo2.impl.Node;
import io.quarkus.gizmo2.impl.TryFinally;
import io.quarkus.gizmo2.impl.constant.ConstImpl;
import java.lang.constant.ClassDesc;
import java.lang.invoke.TypeDescriptor;
import java.util.Objects;
import java.util.function.BiFunction;

final class Return
extends Item {
    static final Return RETURN_VOID = new Return(ConstImpl.ofVoid());
    private final Item returnValue;

    Return(Expr returnValue) {
        this.returnValue = (Item)returnValue;
    }

    @Override
    public boolean mayFallThrough() {
        return false;
    }

    @Override
    protected Node forEachDependency(Node node, BiFunction<Item, Node, Node> op) {
        return this.returnValue.process(node.prev(), op);
    }

    @Override
    public void writeCode(CodeBuilder cb, BlockCreatorImpl from) {
        TryFinally tryFinally = from.tryFinally();
        ClassDesc returnType = from.returnType();
        if (tryFinally != null) {
            cb.goto_(tryFinally.cleanup(new ReturnKey(returnType)));
        } else {
            cb.return_(TypeKind.from((TypeDescriptor.OfField)returnType));
        }
    }

    static final class ReturnKey
    extends TryFinally.CleanupKey {
        private final ClassDesc returnType;

        ReturnKey(ClassDesc returnType) {
            this.returnType = returnType;
        }

        @Override
        ClassDesc type() {
            return this.returnType;
        }

        @Override
        void terminate(BlockCreatorImpl bci, Expr input) {
            bci.return_(input);
        }

        public boolean equals(Object obj) {
            ReturnKey rk;
            return obj instanceof ReturnKey && this.equals(rk = (ReturnKey)obj);
        }

        public boolean equals(ReturnKey other) {
            return this == other || other != null && this.returnType.equals(other.returnType);
        }

        public int hashCode() {
            return Objects.hash(ReturnKey.class, this.returnType);
        }
    }
}

