/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.github.dmlloyd.classfile.CodeBuilder;
import io.github.dmlloyd.classfile.TypeKind;
import io.quarkus.gizmo2.impl.BlockCreatorImpl;
import io.quarkus.gizmo2.impl.Conversions;
import io.quarkus.gizmo2.impl.Item;
import io.quarkus.gizmo2.impl.Node;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDescs;
import java.lang.invoke.TypeDescriptor;
import java.util.function.BiFunction;

final class ArrayStore
extends Item {
    private final Item arrayExpr;
    private final Item index;
    private final Item value;
    private final ClassDesc componentType;

    ArrayStore(Item arrayExpr, Item index, Item value, ClassDesc componentType) {
        this.arrayExpr = arrayExpr;
        this.index = Conversions.convert(index, ConstantDescs.CD_int);
        this.value = Conversions.convert(value, componentType);
        this.componentType = componentType;
    }

    Item arrayExpr() {
        return this.arrayExpr;
    }

    Item index() {
        return this.index;
    }

    Item value() {
        return this.value;
    }

    @Override
    protected Node forEachDependency(Node node, BiFunction<Item, Node, Node> op) {
        return this.arrayExpr.process(this.index.process(this.value.process(node.prev(), op), op), op);
    }

    @Override
    public void writeCode(CodeBuilder cb, BlockCreatorImpl block) {
        cb.arrayStore(TypeKind.from((TypeDescriptor.OfField)this.componentType));
    }
}

