/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.creator.ops;

import io.quarkus.gizmo2.Const;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.TypeKind;
import io.quarkus.gizmo2.creator.BlockCreator;
import io.quarkus.gizmo2.creator.ops.ComparableOps;
import io.quarkus.gizmo2.creator.ops.ObjectOps;

public final class StringOps
extends ObjectOps
implements ComparableOps {
    public StringOps(BlockCreator bc, Expr obj) {
        super(String.class, bc, obj);
    }

    public Expr isEmpty() {
        return this.invokeInstance(Boolean.TYPE, "isEmpty");
    }

    public Expr length() {
        return this.invokeInstance(Integer.TYPE, "length");
    }

    public Expr substring(Expr start) {
        return this.invokeInstance(String.class, "substring", Integer.TYPE, start);
    }

    public Expr substring(int start) {
        return this.substring(Const.of(start));
    }

    public Expr substring(Expr start, Expr end) {
        return this.invokeInstance(String.class, "substring", Integer.TYPE, Integer.TYPE, start, end);
    }

    public Expr substring(int start, int end) {
        return this.substring(Const.of(start), Const.of(end));
    }

    public Expr charAt(Expr index) {
        return this.invokeInstance(Character.TYPE, "charAt", Integer.TYPE, index);
    }

    public Expr charAt(int index) {
        return this.charAt(Const.of(index));
    }

    public Expr codePointAt(Expr index) {
        return this.invokeInstance(Integer.TYPE, "codePointAt", Integer.TYPE, index);
    }

    public Expr codePointAt(int index) {
        return this.codePointAt(Const.of(index));
    }

    public Expr indexOf(Expr item) {
        return switch (item.typeKind().asLoadable()) {
            case TypeKind.INT -> this.invokeInstance(Integer.TYPE, "indexOf", Integer.TYPE, item);
            case TypeKind.REFERENCE -> this.invokeInstance(Integer.TYPE, "indexOf", String.class, item);
            default -> throw new IllegalArgumentException("Invalid item type " + String.valueOf(item.type()));
        };
    }

    public Expr indexOf(int ch) {
        return this.indexOf(Const.of(ch));
    }

    public Expr indexOf(String str) {
        return this.indexOf(Const.of(str));
    }

    public Expr lastIndexOf(Expr item) {
        return switch (item.typeKind().asLoadable()) {
            case TypeKind.INT -> this.invokeInstance(Integer.TYPE, "lastIndexOf", Integer.TYPE, item);
            case TypeKind.REFERENCE -> this.invokeInstance(Integer.TYPE, "lastIndexOf", String.class, item);
            default -> throw new IllegalArgumentException("Invalid item type " + String.valueOf(item.type()));
        };
    }

    public Expr lastIndexOf(int ch) {
        return this.lastIndexOf(Const.of(ch));
    }

    public Expr lastIndexOf(String str) {
        return this.lastIndexOf(Const.of(str));
    }

    public Expr concat(Expr other) {
        return this.invokeInstance(String.class, "concat", String.class, other);
    }

    @Override
    public Expr compareTo(Expr other) {
        return this.invokeInstance(Integer.TYPE, "compareTo", String.class, other);
    }
}

