/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.certs.pem.parsers;

import io.smallrye.certs.pem.parsers.PKPemParser;
import io.vertx.core.buffer.Buffer;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class EncryptedPKCS8Parser
implements PKPemParser {
    private static final String PKCS8_ENCRYPTED_START = "-+BEGIN\\s+ENCRYPTED\\s+PRIVATE\\s+KEY[^-]*-+(?:\\s|\\r|\\n)+";
    private static final String PKCS8_ENCRYPTED_END = "-+END\\s+ENCRYPTED\\s+PRIVATE\\s+KEY[^-]*-+";
    private static final Pattern PATTERN = Pattern.compile("-+BEGIN\\s+ENCRYPTED\\s+PRIVATE\\s+KEY[^-]*-+(?:\\s|\\r|\\n)+([a-z0-9+/=\\r\\n]+)-+END\\s+ENCRYPTED\\s+PRIVATE\\s+KEY[^-]*-+", 2);
    private static final List<String> ALGORITHMS = List.of("RSA", "RSASSA-PSS", "EC", "DSA", "EdDSA", "XDH");
    public static final String PBES2_ALGORITHM = "PBES2";

    @Override
    public PrivateKey getKey(String content, String password) {
        try {
            Matcher matcher = PATTERN.matcher(content);
            if (matcher.find()) {
                String encoded = matcher.group(1);
                byte[] decoded = this.decodeBase64(encoded);
                return this.extract(decoded, password);
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    private PrivateKey extract(byte[] decoded, String password) {
        PKCS8EncodedKeySpec key = EncryptedPKCS8Parser.decrypt(decoded, password);
        for (String algo : ALGORITHMS) {
            try {
                KeyFactory factory = KeyFactory.getInstance(algo);
                return factory.generatePrivate(key);
            }
            catch (NoSuchAlgorithmException | InvalidKeySpecException generalSecurityException) {
            }
        }
        return null;
    }

    static PKCS8EncodedKeySpec decrypt(byte[] bytes, String password) {
        try {
            EncryptedPrivateKeyInfo keyInfo = new EncryptedPrivateKeyInfo(bytes);
            AlgorithmParameters algorithmParameters = keyInfo.getAlgParameters();
            String encryptionAlgorithm = EncryptedPKCS8Parser.getEncryptionAlgorithm(algorithmParameters, keyInfo.getAlgName());
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(encryptionAlgorithm);
            SecretKey key = keyFactory.generateSecret(new PBEKeySpec(password.toCharArray()));
            Cipher cipher = Cipher.getInstance(encryptionAlgorithm);
            cipher.init(2, (Key)key, algorithmParameters);
            return keyInfo.getKeySpec(cipher);
        }
        catch (IOException | GeneralSecurityException ex) {
            throw new IllegalArgumentException("Error decrypting private key", ex);
        }
    }

    private static String getEncryptionAlgorithm(AlgorithmParameters algParameters, String algName) {
        if (algParameters != null && PBES2_ALGORITHM.equals(algName)) {
            return algParameters.toString();
        }
        return algName;
    }

    public Buffer decryptKey(String content, String secret) {
        PrivateKey pk = this.getKey(content, secret);
        if (pk == null) {
            return null;
        }
        Buffer buffer = Buffer.buffer();
        buffer.appendString("-----BEGIN PRIVATE KEY-----\n");
        buffer.appendString(Base64.getEncoder().encodeToString(pk.getEncoded()));
        buffer.appendString("\n-----END PRIVATE KEY-----\n\n");
        return buffer;
    }
}

