/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect.unique;

import org.hibernate.boot.Metadata;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.unique.SkipNullableUniqueDelegate;
import org.hibernate.mapping.UniqueKey;

public class InformixUniqueDelegate
extends SkipNullableUniqueDelegate {
    public InformixUniqueDelegate(Dialect dialect) {
        super(dialect);
    }

    protected void appendUniqueConstraint(StringBuilder fragment, UniqueKey uniqueKey) {
        if (!uniqueKey.hasNullableColumn()) {
            fragment.append(", ");
            fragment.append(this.uniqueConstraintSql(uniqueKey));
            if (uniqueKey.isNameExplicit()) {
                fragment.append(" constraint ").append(uniqueKey.getName());
            }
        }
    }

    public String getAlterTableToAddUniqueKeyCommand(UniqueKey uniqueKey, Metadata metadata, SqlStringGenerationContext context) {
        if (uniqueKey.hasNullableColumn() || !context.isMigration()) {
            return "";
        }
        String tableName = context.format(uniqueKey.getTable().getQualifiedTableName());
        String constraintName = this.dialect.quote(uniqueKey.getName());
        return this.dialect.getAlterTableString(tableName) + " add constraint " + this.uniqueConstraintSql(uniqueKey) + " constraint " + constraintName;
    }
}

