/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect.pagination;

import org.hibernate.dialect.pagination.AbstractNoOffsetLimitHandler;
import org.hibernate.query.spi.Limit;
import org.hibernate.sql.ast.spi.ParameterMarkerStrategy;

public class FirstLimitHandler
extends AbstractNoOffsetLimitHandler {
    public static final FirstLimitHandler INSTANCE = new FirstLimitHandler(false);

    public FirstLimitHandler(boolean variableLimit) {
        super(variableLimit);
    }

    protected String limitClause() {
        return " first ?";
    }

    protected String limitClause(int jdbcParameterCount, ParameterMarkerStrategy parameterMarkerStrategy) {
        return " first " + parameterMarkerStrategy.createMarker(1, null) + " rows only";
    }

    protected String insert(String first, String sql) {
        return FirstLimitHandler.insertAfterSelect((String)first, (String)sql);
    }

    public boolean bindLimitParametersFirst() {
        return true;
    }

    public boolean processSqlMutatesState() {
        return false;
    }

    public int getParameterPositionStart(Limit limit) {
        return FirstLimitHandler.hasMaxRows((Limit)limit) && this.supportsVariableLimit() ? 2 : 1;
    }
}

