/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect.function.array;

import java.util.List;
import org.hibernate.dialect.function.array.AbstractArrayFillFunction;
import org.hibernate.dialect.function.array.DdlTypeHelper;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.type.spi.TypeConfiguration;

public class GaussDBArrayFillFunction
extends AbstractArrayFillFunction {
    public GaussDBArrayFillFunction(boolean list) {
        super(list);
    }

    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        String elementCastType;
        sqlAppender.append((CharSequence)"array_fill(");
        Expression elementExpression = (Expression)sqlAstArguments.get(0);
        if (GaussDBArrayFillFunction.needsElementCasting(elementExpression)) {
            elementCastType = DdlTypeHelper.getCastTypeName((JdbcMappingContainer)elementExpression.getExpressionType(), (TypeConfiguration)walker.getSessionFactory().getTypeConfiguration());
            sqlAppender.append((CharSequence)"cast(");
        } else {
            elementCastType = null;
        }
        sqlAstArguments.get(0).accept(walker);
        if (elementCastType != null) {
            sqlAppender.append((CharSequence)" as ");
            sqlAppender.append((CharSequence)elementCastType);
            sqlAppender.append(')');
        }
        sqlAppender.append((CharSequence)",array[");
        sqlAstArguments.get(1).accept(walker);
        sqlAppender.append((CharSequence)"])");
    }

    private static boolean needsElementCasting(Expression elementExpression) {
        return elementExpression instanceof Literal && (elementExpression.getExpressionType().getSingleJdbcMapping().getJdbcType().isString() || ((Literal)elementExpression).getLiteralValue() == null);
    }
}

