/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.commands.remote;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.CompletionStage;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.util.ByteString;
import org.infinispan.xsite.commands.remote.XSiteCacheRequest;
import org.infinispan.xsite.commands.remote.XSiteRequest;

public class XSiteStateTransferControlRequest
extends XSiteCacheRequest<Void> {
    private boolean startReceive;

    public XSiteStateTransferControlRequest(ByteString cacheName, boolean startReceive) {
        super(cacheName);
        this.startReceive = startReceive;
    }

    public XSiteStateTransferControlRequest() {
        super(null);
    }

    @Override
    protected CompletionStage<Void> invokeInLocalCache(String origin, ComponentRegistry registry) {
        return registry.getBackupReceiver().running().handleStateTransferControl(origin, this.startReceive);
    }

    @Override
    public byte getCommandId() {
        return 0;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeBoolean(this.startReceive);
        super.writeTo(output);
    }

    @Override
    public XSiteRequest<Void> readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.startReceive = input.readBoolean();
        return super.readFrom(input);
    }
}

