/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import org.infinispan.conflict.ConflictManager;
import org.infinispan.conflict.impl.DefaultConflictManager;
import org.infinispan.conflict.impl.InternalConflictManager;
import org.infinispan.conflict.impl.StateReceiver;
import org.infinispan.conflict.impl.StateReceiverImpl;
import org.infinispan.factories.AbstractNamedCacheComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.statetransfer.StateConsumer;
import org.infinispan.statetransfer.StateConsumerImpl;
import org.infinispan.statetransfer.StateProvider;
import org.infinispan.statetransfer.StateProviderImpl;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.statetransfer.StateTransferManagerImpl;
import org.infinispan.util.logging.Log;

@DefaultFactoryFor(classes={StateTransferManager.class, StateConsumer.class, StateProvider.class, StateReceiver.class, ConflictManager.class, InternalConflictManager.class})
public class StateTransferComponentFactory
extends AbstractNamedCacheComponentFactory
implements AutoInstantiableFactory {
    @Override
    public Object construct(String componentName) {
        if (!this.configuration.clustering().cacheMode().isClustered()) {
            return null;
        }
        if (componentName.equals(StateTransferManager.class.getName())) {
            return new StateTransferManagerImpl();
        }
        if (componentName.equals(StateProvider.class.getName())) {
            return new StateProviderImpl();
        }
        if (componentName.equals(StateConsumer.class.getName())) {
            return new StateConsumerImpl();
        }
        if (componentName.equals(StateReceiver.class.getName())) {
            return new StateReceiverImpl();
        }
        if (componentName.equals(ConflictManager.class.getName()) || componentName.equals(InternalConflictManager.class.getName())) {
            return new DefaultConflictManager();
        }
        throw Log.CONTAINER.factoryCannotConstructComponent(componentName);
    }
}

