/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.helpers.spies;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.spies.MultiOnCancellationSpy;
import io.smallrye.mutiny.helpers.spies.MultiOnCompletionSpy;
import io.smallrye.mutiny.helpers.spies.MultiOnFailureSpy;
import io.smallrye.mutiny.helpers.spies.MultiOnItemSpy;
import io.smallrye.mutiny.helpers.spies.MultiOnRequestSpy;
import io.smallrye.mutiny.helpers.spies.MultiOnSubscribeSpy;
import io.smallrye.mutiny.helpers.spies.MultiOnTerminationSpy;
import io.smallrye.mutiny.helpers.spies.MultiSpyBase;
import io.smallrye.mutiny.helpers.spies.Spy;
import io.smallrye.mutiny.subscription.MultiSubscriber;

public class MultiGlobalSpy<T>
extends MultiSpyBase<T> {
    private final MultiOnCancellationSpy<T> onCancellationSpy;
    private final MultiOnCompletionSpy<T> onCompletionSpy;
    private final MultiOnFailureSpy<T> onFailureSpy;
    private final MultiOnItemSpy<T> onItemSpy;
    private final MultiOnRequestSpy<T> onRequestSpy;
    private final MultiOnSubscribeSpy<T> onSubscribeSpy;
    private final MultiOnTerminationSpy<T> onTerminationSpy;

    MultiGlobalSpy(Multi<T> upstream) {
        super(upstream);
        this.onCancellationSpy = Spy.onCancellation(upstream);
        this.onCompletionSpy = Spy.onCompletion(this.onCancellationSpy);
        this.onFailureSpy = Spy.onFailure(this.onCompletionSpy);
        this.onItemSpy = Spy.onItem(this.onFailureSpy);
        this.onRequestSpy = Spy.onRequest(this.onItemSpy);
        this.onSubscribeSpy = Spy.onSubscribe(this.onRequestSpy);
        this.onTerminationSpy = Spy.onTermination(this.onSubscribeSpy);
    }

    public MultiOnCancellationSpy<T> onCancellationSpy() {
        return this.onCancellationSpy;
    }

    public MultiOnCompletionSpy<T> onCompletionSpy() {
        return this.onCompletionSpy;
    }

    public MultiOnFailureSpy<T> onFailureSpy() {
        return this.onFailureSpy;
    }

    public MultiOnItemSpy<T> onItemSpy() {
        return this.onItemSpy;
    }

    public MultiOnRequestSpy<T> onRequestSpy() {
        return this.onRequestSpy;
    }

    public MultiOnSubscribeSpy<T> onSubscribeSpy() {
        return this.onSubscribeSpy;
    }

    public MultiOnTerminationSpy<T> onTerminationSpy() {
        return this.onTerminationSpy;
    }

    @Override
    public void subscribe(MultiSubscriber<? super T> downstream) {
        this.onTerminationSpy.subscribe().withSubscriber(downstream);
    }

    @Override
    public long invocationCount() {
        return this.onCancellationSpy.invocationCount() + this.onCompletionSpy.invocationCount() + this.onFailureSpy.invocationCount() + this.onItemSpy.invocationCount() + this.onRequestSpy.invocationCount() + this.onSubscribeSpy.invocationCount() + this.onTerminationSpy.invocationCount();
    }

    @Override
    public boolean invoked() {
        return this.invocationCount() > 0L;
    }

    @Override
    public void reset() {
        this.onCancellationSpy.reset();
        this.onCompletionSpy.reset();
        this.onFailureSpy.reset();
        this.onItemSpy.reset();
        this.onRequestSpy.reset();
        this.onSubscribeSpy.reset();
        this.onTerminationSpy.reset();
    }

    @Override
    public String toString() {
        return "MultiGlobalSpy{onCancellationSpy=" + String.valueOf(this.onCancellationSpy) + ", onCompletionSpy=" + String.valueOf(this.onCompletionSpy) + ", onFailureSpy=" + String.valueOf(this.onFailureSpy) + ", onItemSpy=" + String.valueOf(this.onItemSpy) + ", onRequestSpy=" + String.valueOf(this.onRequestSpy) + ", onSubscribeSpy=" + String.valueOf(this.onSubscribeSpy) + ", onTerminationSpy=" + String.valueOf(this.onTerminationSpy) + "} " + super.toString();
    }
}

