/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Optional;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.oid4vci.CredentialScopeModel;
import org.keycloak.protocol.oid4vc.model.Claim;
import org.keycloak.util.JsonSerialization;

public class Claims
extends ArrayList<Claim> {
    public static Claims parse(KeycloakSession keycloakSession, CredentialScopeModel credentialScope) {
        Claims claims = new Claims();
        credentialScope.getOid4vcProtocolMappersStream().forEach((? super T protocolMapper) -> {
            Optional<Claim> claim = Claim.parse(keycloakSession, credentialScope.getFormat(), protocolMapper);
            claim.ifPresent(claims::add);
        });
        return claims;
    }

    public String toJsonString() {
        try {
            return JsonSerialization.writeValueAsString((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Claims fromJsonString(String jsonString) {
        try {
            return (Claims)JsonSerialization.readValue((String)jsonString, Claims.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

