/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.issuance.keybinding;

import jakarta.annotation.Nullable;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import org.keycloak.TokenVerifier;
import org.keycloak.common.VerificationException;
import org.keycloak.common.util.Base64;
import org.keycloak.crypto.KeyUse;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.crypto.SignatureProvider;
import org.keycloak.crypto.SignatureSignerContext;
import org.keycloak.crypto.SignatureVerifierContext;
import org.keycloak.jose.jws.JWSBuilder;
import org.keycloak.models.KeycloakContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.oid4vc.issuance.OID4VCIssuerWellKnownProvider;
import org.keycloak.protocol.oid4vc.issuance.keybinding.CNonceHandler;
import org.keycloak.protocol.oid4vc.model.JwtCNonce;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.saml.RandomSecret;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtCNonceHandler
implements CNonceHandler {
    public static final String SOURCE_ENDPOINT = "source_endpoint";
    public static final int NONCE_DEFAULT_LENGTH = 50;
    public static final int NONCE_LENGTH_RANDOM_OFFSET = 15;
    private static final Logger logger = LoggerFactory.getLogger(JwtCNonceHandler.class);
    private final KeycloakSession keycloakSession;
    private final KeyWrapper signingKey;

    public JwtCNonceHandler(KeycloakSession keycloakSession) {
        this.keycloakSession = keycloakSession;
        this.signingKey = this.selectSigningKey(keycloakSession.getContext().getRealm());
    }

    @Override
    public String buildCNonce(List<String> audiences, Map<String, Object> additionalDetails) {
        RealmModel realm = this.keycloakSession.getContext().getRealm();
        String issuer = OID4VCIssuerWellKnownProvider.getIssuer(this.keycloakSession.getContext());
        Integer nonceLifetimeMillis = realm.getAttribute("vc.c-nonce-lifetime-seconds", Integer.valueOf(60));
        audiences = Optional.ofNullable(audiences).orElseGet(Collections::emptyList);
        Instant now = Instant.now();
        long expiresAt = now.plus((long)nonceLifetimeMillis.intValue(), ChronoUnit.SECONDS).getEpochSecond();
        int nonceLength = 50 + new Random().nextInt(15);
        String strongSalt = Base64.encodeBytes((byte[])RandomSecret.createRandomSecret((int)nonceLength));
        JsonWebToken jwtCNonce = new JwtCNonce().salt(strongSalt).issuer(issuer).audience((String[])audiences.toArray(String[]::new)).exp(Long.valueOf(expiresAt));
        Optional.ofNullable(additionalDetails).ifPresent(map -> map.forEach((arg_0, arg_1) -> ((JsonWebToken)jwtCNonce).setOtherClaims(arg_0, arg_1)));
        SignatureProvider signatureProvider = (SignatureProvider)this.keycloakSession.getProvider(SignatureProvider.class, this.signingKey.getAlgorithm());
        SignatureSignerContext signatureSignerContext = signatureProvider.signer(this.signingKey);
        return new JWSBuilder().jsonContent((Object)jwtCNonce).sign(signatureSignerContext);
    }

    @Override
    public void verifyCNonce(String cNonce, List<String> audiences, @Nullable Map<String, Object> additionalDetails) throws VerificationException {
        if (cNonce == null) {
            throw new VerificationException("c_nonce is required");
        }
        TokenVerifier verifier = TokenVerifier.create((String)cNonce, JsonWebToken.class);
        KeycloakContext keycloakContext = this.keycloakSession.getContext();
        ArrayList<TokenVerifier.Predicate> verifiers = new ArrayList<TokenVerifier.Predicate>(List.of(jwt -> {
            String expectedIssuer = OID4VCIssuerWellKnownProvider.getIssuer(keycloakContext);
            if (!expectedIssuer.equals(jwt.getIssuer())) {
                String message = String.format("c_nonce issuer did not match: %s(expected) != %s(actual)", expectedIssuer, jwt.getIssuer());
                throw new VerificationException(message);
            }
            return true;
        }, jwt -> {
            List actualValue = Optional.ofNullable(jwt.getAudience()).map(Arrays::asList).orElse(List.of());
            return this.checkAttributeEquality("aud", audiences, actualValue);
        }, jwt -> {
            String salt = Optional.ofNullable(jwt.getOtherClaims()).map(m -> String.valueOf(m.get("salt"))).orElse(null);
            int saltLength = Optional.ofNullable(salt).map(String::length).orElse(0);
            if (saltLength < 50) {
                String message = String.format("c_nonce-salt is not of expected length: %s(actual) < %s(expected)", saltLength, 50);
                throw new VerificationException(message);
            }
            return true;
        }, jwt -> {
            Long exp = jwt.getExp();
            if (exp == null) {
                throw new VerificationException("c_nonce has no expiration time");
            }
            long now = Instant.now().getEpochSecond();
            if (exp < now) {
                String message = String.format("c_nonce not valid: %s(exp) < %s(now)", exp, now);
                throw new VerificationException(message);
            }
            return true;
        }));
        Optional.ofNullable(additionalDetails).ifPresent(map -> map.forEach((key, object) -> verifiers.add(jwt -> {
            Object actualValue = Optional.ofNullable(jwt.getOtherClaims()).map(claimMap -> claimMap.get(key)).orElse(null);
            return this.checkAttributeEquality((String)key, object, actualValue);
        })));
        verifier.withChecks(verifiers.toArray(new TokenVerifier.Predicate[0]));
        SignatureVerifierContext signatureVerifier = ((SignatureProvider)this.keycloakSession.getProvider(SignatureProvider.class, this.signingKey.getAlgorithm())).verifier(this.signingKey);
        verifier.verifierContext(signatureVerifier);
        verifier.verify();
    }

    protected boolean checkAttributeEquality(String key, Object object, Object actualValue) throws VerificationException {
        boolean isEqual = Objects.equals(object, actualValue);
        if (!isEqual) {
            String message = String.format("c_nonce: expected '%s' to be equal to '%s' but actual value was '%s'", key, object, actualValue);
            throw new VerificationException(message);
        }
        return isEqual;
    }

    protected KeyWrapper selectSigningKey(RealmModel realm) {
        KeyWrapper signingKey;
        try {
            signingKey = this.keycloakSession.keys().getActiveKey(realm, KeyUse.SIG, "ES256");
        }
        catch (RuntimeException ex) {
            logger.debug("Failed to find active ES256 signing key for realm {}. Falling back to RSA...", (Object)realm.getName());
            logger.debug(ex.getMessage(), (Throwable)ex);
            signingKey = this.keycloakSession.keys().getActiveKey(realm, KeyUse.SIG, "RS256");
        }
        return signingKey;
    }
}

