/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.issuance;

import jakarta.ws.rs.core.UriBuilder;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Time;
import org.keycloak.crypto.CryptoUtils;
import org.keycloak.crypto.KeyUse;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.crypto.SignatureProvider;
import org.keycloak.crypto.SignatureSignerContext;
import org.keycloak.http.HttpResponse;
import org.keycloak.jose.jwk.JSONWebKeySet;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.jose.jws.JWSBuilder;
import org.keycloak.models.KeyManager;
import org.keycloak.models.KeycloakContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakUriInfo;
import org.keycloak.models.RealmModel;
import org.keycloak.models.oid4vci.CredentialScopeModel;
import org.keycloak.protocol.oid4vc.model.CredentialIssuer;
import org.keycloak.protocol.oid4vc.model.CredentialRequestEncryptionMetadata;
import org.keycloak.protocol.oid4vc.model.CredentialResponseEncryptionMetadata;
import org.keycloak.protocol.oid4vc.model.SupportedCredentialConfiguration;
import org.keycloak.protocol.oidc.utils.JWKSServerUtils;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.services.Urls;
import org.keycloak.services.resources.ServerMetadataResource;
import org.keycloak.urls.UrlType;
import org.keycloak.util.JsonSerialization;
import org.keycloak.wellknown.WellKnownProvider;

public class OID4VCIssuerWellKnownProvider
implements WellKnownProvider {
    private static final Logger LOGGER = Logger.getLogger(OID4VCIssuerWellKnownProvider.class);
    public static final String SIGNED_METADATA_ENABLED_ATTR = "oid4vci.signed_metadata.enabled";
    public static final String SIGNED_METADATA_LIFESPAN_ATTR = "oid4vci.signed_metadata.lifespan";
    public static final String SIGNED_METADATA_ALG_ATTR = "oid4vci.signed_metadata.alg";
    public static final String VC_KEY = "vc";
    public static final String ATTR_ENCRYPTION_REQUIRED = "oid4vci.encryption.required";
    public static final String DEFLATE_COMPRESSION = "DEF";
    public static final String ATTR_REQUEST_ZIP_ALGS = "oid4vci.request.zip.algorithms";
    protected final KeycloakSession keycloakSession;

    public OID4VCIssuerWellKnownProvider(KeycloakSession keycloakSession) {
        this.keycloakSession = keycloakSession;
    }

    public void close() {
    }

    @Override
    public Object getConfig() {
        CredentialIssuer issuer = this.getIssuerMetadata();
        return this.getMetadataResponse(issuer, this.keycloakSession);
    }

    public CredentialIssuer getIssuerMetadata() {
        KeycloakContext context = this.keycloakSession.getContext();
        CredentialResponseEncryptionMetadata responseEnc = OID4VCIssuerWellKnownProvider.getCredentialResponseEncryption(this.keycloakSession);
        CredentialRequestEncryptionMetadata requestEnc = OID4VCIssuerWellKnownProvider.getCredentialRequestEncryption(this.keycloakSession);
        if (responseEnc != null && requestEnc == null) {
            LOGGER.warn((Object)"credential_response_encryption is advertised but credential_request_encryption metadata is not available. If response encryption is included, request encryption should also be included. keep response metadata and setting encryption_required=false.");
            if (Boolean.TRUE.equals(responseEnc.getEncryptionRequired())) {
                responseEnc.setEncryptionRequired(false);
            }
        }
        if (responseEnc != null && requestEnc != null) {
            boolean responseRequired = Boolean.TRUE.equals(responseEnc.getEncryptionRequired());
            boolean requestRequired = Boolean.TRUE.equals(requestEnc.isEncryptionRequired());
            if (responseRequired && !requestRequired) {
                LOGGER.warn((Object)"credential_response_encryption.encryption_required=true while credential_request_encryption.encryption_required is false. Marking request encryption as required to maintain consistency.");
                requestEnc.setEncryptionRequired(true);
            }
        }
        this.addDeprecationHeadersIfOldRoute(this.keycloakSession);
        return new CredentialIssuer().setCredentialIssuer(OID4VCIssuerWellKnownProvider.getIssuer(context)).setCredentialEndpoint(OID4VCIssuerWellKnownProvider.getCredentialsEndpoint(context)).setNonceEndpoint(OID4VCIssuerWellKnownProvider.getNonceEndpoint(context)).setDeferredCredentialEndpoint(OID4VCIssuerWellKnownProvider.getDeferredCredentialEndpoint(context)).setCredentialsSupported(OID4VCIssuerWellKnownProvider.getSupportedCredentials(this.keycloakSession)).setAuthorizationServers(List.of(OID4VCIssuerWellKnownProvider.getIssuer(context))).setCredentialResponseEncryption(responseEnc).setCredentialRequestEncryption(requestEnc).setBatchCredentialIssuance(this.getBatchCredentialIssuance(this.keycloakSession));
    }

    public Object getMetadataResponse(CredentialIssuer issuer, KeycloakSession session) {
        RealmModel realm = session.getContext().getRealm();
        String acceptHeader = session.getContext().getRequestHeaders().getHeaderString("Accept");
        boolean preferJwt = acceptHeader != null && acceptHeader.contains("application/jwt");
        boolean signedMetadataEnabled = Boolean.parseBoolean(realm.getAttribute(SIGNED_METADATA_ENABLED_ATTR));
        if (preferJwt && signedMetadataEnabled) {
            Optional<String> signedJwt = this.generateSignedMetadata(issuer, session);
            if (signedJwt.isPresent()) {
                return signedJwt.get();
            }
            LOGGER.debugf("Falling back to JSON response due to signed metadata failure for realm: %s", (Object)realm.getName());
        }
        return issuer;
    }

    private static String getDeferredCredentialEndpoint(KeycloakContext context) {
        return OID4VCIssuerWellKnownProvider.getIssuer(context) + "/protocol/oid4vc/deferred_credential";
    }

    private CredentialIssuer.BatchCredentialIssuance getBatchCredentialIssuance(KeycloakSession session) {
        return OID4VCIssuerWellKnownProvider.getBatchCredentialIssuance(session.getContext().getRealm());
    }

    public static CredentialIssuer.BatchCredentialIssuance getBatchCredentialIssuance(RealmModel realm) {
        String batchSize = realm.getAttribute("batch_credential_issuance.batch_size");
        if (batchSize != null) {
            try {
                int parsedBatchSize = Integer.parseInt(batchSize);
                if (parsedBatchSize < 2) {
                    LOGGER.warnf("%s must be 2 or greater, but was %d. Skipping batch_credential_issuance.", (Object)"batch_credential_issuance.batch_size", (Object)parsedBatchSize);
                    return null;
                }
                return new CredentialIssuer.BatchCredentialIssuance().setBatchSize(parsedBatchSize);
            }
            catch (Exception e) {
                LOGGER.warnf((Throwable)e, "Failed to parse %s from realm attributes.", (Object)"batch_credential_issuance.batch_size");
            }
        }
        return null;
    }

    public Optional<String> generateSignedMetadata(CredentialIssuer metadata, KeycloakSession session) {
        String alg;
        RealmModel realm = session.getContext().getRealm();
        KeyManager keyManager = session.keys();
        try {
            alg = this.getSigningAlgorithm(realm, session);
        }
        catch (IllegalStateException e) {
            LOGGER.warnf("Failed to get signing algorithm: %s. Falling back to unsigned metadata.", (Object)e.getMessage());
            return Optional.empty();
        }
        KeyWrapper keyWrapper = keyManager.getActiveKey(realm, KeyUse.SIG, alg);
        if (keyWrapper == null) {
            LOGGER.warnf("No active key found for realm '%s' with algorithm '%s'. Falling back to unsigned metadata.", (Object)realm.getName(), (Object)alg);
            return Optional.empty();
        }
        JsonWebToken jwt = this.createMetadataJwt(metadata, realm);
        String lifespanStr = realm.getAttribute(SIGNED_METADATA_LIFESPAN_ATTR);
        if (lifespanStr != null) {
            try {
                long lifespan = Long.parseLong(lifespanStr);
                jwt.exp(Long.valueOf((long)Time.currentTime() + lifespan));
            }
            catch (NumberFormatException e) {
                LOGGER.warnf("Invalid lifespan duration for signed metadata: %s. Falling back to unsigned metadata.", (Object)lifespanStr);
                return Optional.empty();
            }
        }
        JWSBuilder jwsBuilder = new JWSBuilder().type("openidvci-issuer-metadata+jwt").kid(keyWrapper.getKid());
        this.addCertificateHeaders(jwsBuilder, keyWrapper, realm);
        SignatureProvider signerProvider = (SignatureProvider)session.getProvider(SignatureProvider.class, alg);
        if (signerProvider == null) {
            LOGGER.warnf("No signature provider for algorithm: %s. Falling back to unsigned metadata.", (Object)alg);
            return Optional.empty();
        }
        SignatureSignerContext signer = signerProvider.signer(keyWrapper);
        if (signer == null) {
            LOGGER.warnf("No signer context for algorithm: %s. Falling back to unsigned metadata.", (Object)alg);
            return Optional.empty();
        }
        try {
            return Optional.of(jwsBuilder.jsonContent((Object)jwt).sign(signer));
        }
        catch (Exception e) {
            LOGGER.warnf((Throwable)e, "Failed to sign metadata. Falling back to unsigned metadata.", new Object[0]);
            return Optional.empty();
        }
    }

    private String getSigningAlgorithm(RealmModel realm, KeycloakSession session) {
        List<String> supportedAlgorithms = OID4VCIssuerWellKnownProvider.getSupportedAsymmetricSignatureAlgorithms(session);
        if (supportedAlgorithms.isEmpty()) {
            throw new IllegalStateException("No asymmetric signing algorithms available for realm: " + realm.getName());
        }
        String configuredAlg = realm.getAttribute(SIGNED_METADATA_ALG_ATTR);
        if (configuredAlg != null) {
            if (!supportedAlgorithms.contains(configuredAlg)) {
                throw new IllegalStateException("Configured signing algorithm '" + configuredAlg + "' is not supported for realm: " + realm.getName());
            }
            return configuredAlg;
        }
        return supportedAlgorithms.contains("RS256") ? "RS256" : supportedAlgorithms.get(0);
    }

    private JsonWebToken createMetadataJwt(CredentialIssuer metadata, RealmModel realm) {
        JsonWebToken jwt = new JsonWebToken();
        jwt.subject(metadata.getCredentialIssuer());
        jwt.issuer(metadata.getCredentialIssuer());
        jwt.issuedNow();
        Map metadataClaims = (Map)JsonSerialization.mapper.convertValue((Object)metadata, Map.class);
        metadataClaims.forEach((arg_0, arg_1) -> ((JsonWebToken)jwt).setOtherClaims(arg_0, arg_1));
        return jwt;
    }

    private void addCertificateHeaders(JWSBuilder jwsBuilder, KeyWrapper keyWrapper, RealmModel realm) {
        if (keyWrapper.getCertificateChain() != null && !keyWrapper.getCertificateChain().isEmpty()) {
            jwsBuilder.x5c(keyWrapper.getCertificateChain());
        } else if (keyWrapper.getCertificate() != null) {
            jwsBuilder.x5c(List.of(keyWrapper.getCertificate()));
        } else {
            LOGGER.debugf("No certificate or certificate chain available for x5c header in realm: %s", (Object)realm.getName());
        }
    }

    public static CredentialResponseEncryptionMetadata getCredentialResponseEncryption(KeycloakSession session) {
        RealmModel realm = session.getContext().getRealm();
        CredentialResponseEncryptionMetadata metadata = new CredentialResponseEncryptionMetadata();
        metadata.setAlgValuesSupported(OID4VCIssuerWellKnownProvider.getSupportedEncryptionAlgorithms(session)).setEncValuesSupported(OID4VCIssuerWellKnownProvider.getSupportedEncryptionMethods()).setZipValuesSupported(OID4VCIssuerWellKnownProvider.getSupportedZipAlgorithms(realm)).setEncryptionRequired(OID4VCIssuerWellKnownProvider.isEncryptionRequired(realm));
        return metadata;
    }

    public static CredentialRequestEncryptionMetadata getCredentialRequestEncryption(KeycloakSession session) {
        RealmModel realm = session.getContext().getRealm();
        JSONWebKeySet jwks = OID4VCIssuerWellKnownProvider.buildJwks(session);
        boolean encryptionRequired = OID4VCIssuerWellKnownProvider.isEncryptionRequired(realm);
        if (jwks.getKeys() == null || jwks.getKeys().length == 0) {
            if (encryptionRequired) {
                LOGGER.error((Object)"Encryption is required but no valid encryption keys are available.");
                throw new IllegalStateException("Missing encryption keys for required credential_request_encryption.");
            }
            LOGGER.warn((Object)"No valid encryption keys found; omitting credential_request_encryption metadata.");
            return null;
        }
        CredentialRequestEncryptionMetadata metadata = new CredentialRequestEncryptionMetadata().setJwks(jwks).setEncValuesSupported(OID4VCIssuerWellKnownProvider.getSupportedEncryptionMethods()).setZipValuesSupported(OID4VCIssuerWellKnownProvider.getSupportedZipAlgorithms(realm)).setEncryptionRequired(encryptionRequired);
        return metadata;
    }

    public static List<String> getSupportedEncryptionAlgorithms(KeycloakSession session) {
        boolean hasRsaKeys;
        RealmModel realm = session.getContext().getRealm();
        KeyManager keyManager = session.keys();
        List<String> supportedEncryptionAlgorithms = CryptoUtils.getSupportedAsymmetricEncryptionAlgorithms(session);
        if (supportedEncryptionAlgorithms.isEmpty() && (hasRsaKeys = keyManager.getKeysStream(realm).filter(key -> KeyUse.ENC.equals((Object)key.getUse())).anyMatch(key -> "RSA".equals(key.getType())))) {
            supportedEncryptionAlgorithms.add("RSA-OAEP");
            supportedEncryptionAlgorithms.add("RSA-OAEP-256");
        }
        return supportedEncryptionAlgorithms;
    }

    private static JSONWebKeySet buildJwks(KeycloakSession session) {
        RealmModel realm = session.getContext().getRealm();
        JSONWebKeySet jwks = JWKSServerUtils.getRealmJwks(session, realm);
        JWK[] encKeys = (JWK[])Arrays.stream(jwks.getKeys()).filter(jwk -> JWK.Use.ENCRYPTION.asString().equals(jwk.getPublicKeyUse())).filter(jwk -> jwk.getKeyType() != null && !jwk.getKeyType().equals("oct")).toArray(JWK[]::new);
        jwks.setKeys(encKeys);
        return jwks;
    }

    private static List<String> getSupportedZipAlgorithms(RealmModel realm) {
        String zipAlgs = realm.getAttribute(ATTR_REQUEST_ZIP_ALGS);
        if (zipAlgs != null && !zipAlgs.isEmpty()) {
            return Arrays.stream(zipAlgs.split(",")).map(String::trim).filter(alg -> alg.equals(DEFLATE_COMPRESSION)).collect(Collectors.toList());
        }
        return null;
    }

    private static List<String> getSupportedEncryptionMethods() {
        return List.of("A256GCM");
    }

    private static boolean isEncryptionRequired(RealmModel realm) {
        String required = realm.getAttribute(ATTR_ENCRYPTION_REQUIRED);
        return Boolean.parseBoolean(required);
    }

    public static Map<String, SupportedCredentialConfiguration> getSupportedCredentials(KeycloakSession keycloakSession) {
        List<String> globalSupportedSigningAlgorithms = OID4VCIssuerWellKnownProvider.getSupportedSignatureAlgorithms(keycloakSession);
        RealmModel realm = keycloakSession.getContext().getRealm();
        Map<String, SupportedCredentialConfiguration> supportedCredentialConfigurations = keycloakSession.clientScopes().getClientScopesByProtocol(realm, "oid4vc").map(CredentialScopeModel::new).map(clientScope -> SupportedCredentialConfiguration.parse(keycloakSession, clientScope, globalSupportedSigningAlgorithms)).collect(Collectors.toMap(SupportedCredentialConfiguration::getId, sc -> sc, (sc1, sc2) -> sc1));
        return supportedCredentialConfigurations;
    }

    public static SupportedCredentialConfiguration toSupportedCredentialConfiguration(KeycloakSession keycloakSession, CredentialScopeModel credentialModel) {
        List<String> globalSupportedSigningAlgorithms = OID4VCIssuerWellKnownProvider.getSupportedSignatureAlgorithms(keycloakSession);
        return SupportedCredentialConfiguration.parse(keycloakSession, credentialModel, globalSupportedSigningAlgorithms);
    }

    public static String getIssuer(KeycloakContext context) {
        KeycloakUriInfo frontendUriInfo = context.getUri(UrlType.FRONTEND);
        return Urls.realmIssuer(frontendUriInfo.getBaseUri(), context.getRealm().getName());
    }

    public static String getNonceEndpoint(KeycloakContext context) {
        return OID4VCIssuerWellKnownProvider.getIssuer(context) + "/protocol/oid4vc/nonce";
    }

    public static String getCredentialsEndpoint(KeycloakContext context) {
        return OID4VCIssuerWellKnownProvider.getIssuer(context) + "/protocol/oid4vc/credential";
    }

    public static List<String> getSupportedSignatureAlgorithms(KeycloakSession session) {
        RealmModel realm = session.getContext().getRealm();
        KeyManager keyManager = session.keys();
        return keyManager.getKeysStream(realm).filter(key -> KeyUse.SIG.equals((Object)key.getUse())).map(KeyWrapper::getAlgorithm).filter(algorithm -> algorithm != null && !algorithm.isEmpty()).distinct().collect(Collectors.toList());
    }

    public static List<String> getAuthorizationServers(KeycloakSession session) {
        return List.of(OID4VCIssuerWellKnownProvider.getIssuer(session.getContext()));
    }

    public static List<String> getSupportedAsymmetricSignatureAlgorithms(KeycloakSession session) {
        return CryptoUtils.getSupportedAsymmetricSignatureAlgorithms(session);
    }

    private void addDeprecationHeadersIfOldRoute(KeycloakSession session) {
        boolean isOldRoute;
        String requestPath = session.getContext().getUri().getRequestUri().getPath();
        if (requestPath == null) {
            return;
        }
        int idxRealms = requestPath.indexOf("/realms/");
        int idxWellKnown = requestPath.indexOf("/.well-known/");
        boolean bl = isOldRoute = idxRealms >= 0 && idxWellKnown > idxRealms;
        if (!isOldRoute) {
            return;
        }
        UriBuilder base = session.getContext().getUri().getBaseUriBuilder();
        String logKey = session.getContext().getRealm().getName();
        URI successor = ServerMetadataResource.wellKnownOAuthProviderUrl(base).build(new Object[]{"openid-credential-issuer", logKey});
        HttpResponse httpResponse = session.getContext().getHttpResponse();
        httpResponse.setHeader("Warning", "299 - \"Deprecated endpoint; use " + String.valueOf(successor) + "\"");
        httpResponse.setHeader("Deprecation", "true");
        httpResponse.setHeader("Link", "<" + String.valueOf(successor) + ">; rel=\"successor-version\"");
        LOGGER.warnf("Deprecated realm-scoped well-known endpoint accessed for OID4VCI in realm '%s'. Use %s instead.", (Object)logKey, (Object)successor);
    }
}

