/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.organization.utils;

import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.keycloak.TokenVerifier;
import org.keycloak.authentication.actiontoken.inviteorg.InviteOrgActionToken;
import org.keycloak.common.Profile;
import org.keycloak.common.VerificationException;
import org.keycloak.http.HttpRequest;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.OrganizationDomainModel;
import org.keycloak.models.OrganizationModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.organization.OrganizationProvider;
import org.keycloak.organization.protocol.mappers.oidc.OrganizationScope;
import org.keycloak.services.ErrorResponse;
import org.keycloak.sessions.AuthenticationSessionModel;

public class Organizations {
    public static boolean canManageOrganizationGroup(KeycloakSession session, GroupModel group) {
        if (!GroupModel.Type.ORGANIZATION.equals((Object)group.getType())) {
            return true;
        }
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.ORGANIZATION)) {
            OrganizationModel organization = Organizations.resolveOrganization(session);
            return organization != null && organization.getId().equals(group.getName());
        }
        return true;
    }

    public static List<IdentityProviderModel> resolveHomeBroker(KeycloakSession session, UserModel user) {
        OrganizationProvider provider = Organizations.getProvider(session);
        RealmModel realm = session.getContext().getRealm();
        List<OrganizationModel> organizations = Optional.ofNullable(user).stream().flatMap(arg_0 -> ((OrganizationProvider)provider).getByMember(arg_0)).filter(OrganizationModel::isEnabled).filter(org -> org.isManaged(user)).toList();
        if (organizations.isEmpty()) {
            return List.of();
        }
        ArrayList<IdentityProviderModel> brokers = new ArrayList<IdentityProviderModel>();
        for (OrganizationModel organization : organizations) {
            List organizationBrokers = organization.getIdentityProviders().toList();
            session.users().getFederatedIdentitiesStream(realm, user).map(f -> {
                IdentityProviderModel broker = session.identityProviders().getByAlias(f.getIdentityProvider());
                if (!organizationBrokers.contains(broker)) {
                    return null;
                }
                FederatedIdentityModel identity = session.users().getFederatedIdentity(realm, user, broker.getAlias());
                if (identity != null) {
                    return broker;
                }
                return null;
            }).filter(Objects::nonNull).forEach(brokers::add);
        }
        return brokers;
    }

    public static Consumer<GroupModel> removeGroup(KeycloakSession session, RealmModel realm) {
        return group -> {
            if (!GroupModel.Type.ORGANIZATION.equals((Object)group.getType())) {
                realm.removeGroup(group);
                return;
            }
            OrganizationModel current = Organizations.resolveOrganization(session);
            try {
                OrganizationProvider provider = Organizations.getProvider(session);
                session.getContext().setOrganization(provider.getById(group.getName()));
                realm.removeGroup(group);
            }
            finally {
                session.getContext().setOrganization(current);
            }
        };
    }

    public static boolean isEnabledAndOrganizationsPresent(OrganizationProvider orgProvider) {
        return orgProvider != null && orgProvider.isEnabled() && orgProvider.count() != 0L;
    }

    public static boolean isEnabledAndOrganizationsPresent(KeycloakSession session) {
        if (!Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.ORGANIZATION)) {
            return false;
        }
        OrganizationProvider provider = Organizations.getProvider(session);
        return Organizations.isEnabledAndOrganizationsPresent(provider);
    }

    public static void checkEnabled(OrganizationProvider provider) {
        if (provider == null || !provider.isEnabled()) {
            throw ErrorResponse.error("Organizations not enabled for this realm.", Response.Status.NOT_FOUND);
        }
    }

    public static InviteOrgActionToken parseInvitationToken(HttpRequest request) throws VerificationException {
        MultivaluedMap queryParameters = request.getUri().getQueryParameters();
        String tokenFromQuery = (String)queryParameters.getFirst((Object)"token");
        if (tokenFromQuery == null) {
            return null;
        }
        return (InviteOrgActionToken)TokenVerifier.create((String)tokenFromQuery, InviteOrgActionToken.class).getToken();
    }

    public static String getEmailDomain(String email) {
        if (email == null) {
            return null;
        }
        int domainSeparator = email.indexOf(64);
        if (domainSeparator == -1) {
            return null;
        }
        return email.substring(domainSeparator + 1);
    }

    public static String getEmailDomain(UserModel user) {
        if (user == null) {
            return null;
        }
        return Organizations.getEmailDomain(user.getEmail());
    }

    public static OrganizationModel resolveOrganization(KeycloakSession session) {
        return Organizations.resolveOrganization(session, null, null);
    }

    public static OrganizationModel resolveOrganization(KeycloakSession session, UserModel user) {
        return Organizations.resolveOrganization(session, user, null);
    }

    public static OrganizationModel resolveOrganization(KeycloakSession session, UserModel user, String domain) {
        List<OrganizationModel> organizations;
        KeycloakContext context = session.getContext();
        RealmModel realm = context.getRealm();
        if (!realm.isOrganizationsEnabled()) {
            return null;
        }
        OrganizationModel current = context.getOrganization();
        if (current != null) {
            return current;
        }
        OrganizationProvider provider = Organizations.getProvider(session);
        if (provider.count() == 0L) {
            return null;
        }
        AuthenticationSessionModel authSession = context.getAuthenticationSession();
        if (authSession != null) {
            OrganizationScope scope = OrganizationScope.valueOfScope(session);
            List organizations2 = Optional.ofNullable(authSession.getAuthNote("kc.org")).map(arg_0 -> ((OrganizationProvider)provider).getById(arg_0)).map(List::of).orElseGet(() -> scope == null ? List.of() : scope.resolveOrganizations(user, session).toList());
            if (organizations2.size() == 1) {
                OrganizationModel organization = (OrganizationModel)organizations2.get(0);
                if (user == null) {
                    return organization;
                }
                if (organization.isMember(user) || Organizations.matchesOrganizationDomain(organization, user, domain)) {
                    return organization;
                }
                return null;
            }
            if (scope != null && user != null) {
                return Organizations.resolveUserOrganization(organizations2, user, domain).orElse(null);
            }
        }
        if ((organizations = Optional.ofNullable(user).stream().flatMap(arg_0 -> ((OrganizationProvider)provider).getByMember(arg_0)).filter(OrganizationModel::isEnabled).toList()).size() == 1) {
            return organizations.get(0);
        }
        return Organizations.resolveUserOrganization(organizations, user, domain).orElseGet(() -> Organizations.resolveOrganizationByDomain(user, domain, provider));
    }

    public static OrganizationProvider getProvider(KeycloakSession session) {
        return (OrganizationProvider)session.getProvider(OrganizationProvider.class);
    }

    public static boolean isRegistrationAllowed(KeycloakSession session, RealmModel realm) {
        if (session.getContext().getOrganization() != null) {
            return true;
        }
        return realm.isRegistrationAllowed();
    }

    public static boolean isReadOnlyOrganizationMember(KeycloakSession session, UserModel delegate) {
        if (delegate == null) {
            return false;
        }
        if (!Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.ORGANIZATION)) {
            return false;
        }
        OrganizationProvider organizationProvider = Organizations.getProvider(session);
        if (organizationProvider.count() == 0L) {
            return false;
        }
        return organizationProvider.getByMember(delegate).anyMatch(org -> organizationProvider.isEnabled() && org.isManaged(delegate) && !org.isEnabled() || !organizationProvider.isEnabled() && org.isManaged(delegate));
    }

    private static boolean matchesOrganizationDomain(OrganizationModel organization, UserModel user, String domain) {
        if (organization == null) {
            return false;
        }
        String emailDomain = Optional.ofNullable(domain).orElseGet(() -> Organizations.getEmailDomain(user));
        if (emailDomain == null) {
            return false;
        }
        Stream domains = organization.getDomains();
        return domains.map(OrganizationDomainModel::getName).anyMatch(emailDomain::equals);
    }

    private static OrganizationModel resolveOrganizationByDomain(UserModel user, String domain, OrganizationProvider provider) {
        if (user != null && domain == null) {
            domain = Organizations.getEmailDomain(user);
        }
        return Optional.ofNullable(domain).map(arg_0 -> ((OrganizationProvider)provider).getByDomainName(arg_0)).orElse(null);
    }

    private static Optional<OrganizationModel> resolveUserOrganization(List<OrganizationModel> organizations, UserModel user, String domain) {
        OrganizationModel orgByDomain = null;
        for (OrganizationModel o : organizations) {
            if (o.isManaged(user)) {
                return Optional.of(o);
            }
            if (!Organizations.matchesOrganizationDomain(o, user, domain)) continue;
            orgByDomain = o;
        }
        return Optional.ofNullable(orgByDomain);
    }
}

