/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.compatibility;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.common.Profile;
import org.keycloak.compatibility.CompatibilityMetadataProvider;
import org.keycloak.compatibility.CompatibilityResult;
import org.keycloak.util.JsonSerialization;

public class FeatureCompatibilityMetadataProvider
implements CompatibilityMetadataProvider {
    public static final String ID = "feature-compatibility";

    public Map<String, String> metadata() {
        Set features = Profile.getInstance().getAllFeatures();
        HashMap<String, String> metadata = new HashMap<String, String>(features.size());
        for (Profile.Feature f : features) {
            Feature feature = Feature.from(f);
            metadata.compute(f.getUnversionedKey(), (k, v) -> {
                if (v == null) {
                    return FeatureCompatibilityMetadataProvider.toJson(feature);
                }
                Feature existing = FeatureCompatibilityMetadataProvider.fromJson(v);
                if (!existing.enabled || feature.version > existing.version) {
                    return FeatureCompatibilityMetadataProvider.toJson(feature);
                }
                return v;
            });
        }
        return metadata;
    }

    public CompatibilityResult isCompatible(Map<String, String> other) {
        Map<String, String> currentMeta = this.metadata();
        for (Map.Entry<String, String> entry : other.entrySet()) {
            String featureKey = entry.getKey();
            String otherJson = entry.getValue();
            Feature otherFeature = FeatureCompatibilityMetadataProvider.fromJson(otherJson);
            if (!currentMeta.containsKey(featureKey)) {
                if (!otherFeature.enabled || otherFeature.updatePolicy != Profile.FeatureUpdatePolicy.SHUTDOWN) continue;
                return CompatibilityResult.incompatibleAttribute((String)ID, (String)featureKey, (String)otherJson, null);
            }
            String json = currentMeta.get(featureKey);
            Feature feature = FeatureCompatibilityMetadataProvider.fromJson(json);
            if (feature.version != otherFeature.version && feature.updatePolicy == Profile.FeatureUpdatePolicy.ROLLING_NO_UPGRADE) {
                return CompatibilityResult.incompatibleAttribute((String)ID, (String)featureKey, (String)otherJson, (String)json);
            }
            if (feature.enabled == otherFeature.enabled || feature.updatePolicy != Profile.FeatureUpdatePolicy.SHUTDOWN) continue;
            return CompatibilityResult.incompatibleAttribute((String)ID, (String)featureKey, (String)otherJson, (String)json);
        }
        Map<String, String> distinct = currentMeta.entrySet().stream().filter(e -> !other.containsKey(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        for (Map.Entry<String, String> entry : distinct.entrySet()) {
            String json = entry.getValue();
            Feature feature = FeatureCompatibilityMetadataProvider.fromJson(json);
            if (!feature.enabled || feature.updatePolicy != Profile.FeatureUpdatePolicy.SHUTDOWN) continue;
            return CompatibilityResult.incompatibleAttribute((String)ID, (String)entry.getKey(), null, (String)json);
        }
        return CompatibilityResult.providerCompatible((String)ID);
    }

    public String getId() {
        return ID;
    }

    static String toJson(Feature feature) {
        try {
            return JsonSerialization.mapper.writeValueAsString((Object)feature);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Should never happen!", e);
        }
    }

    static Feature fromJson(String json) {
        try {
            return (Feature)JsonSerialization.mapper.readValue(json, Feature.class);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Should never happen!", e);
        }
    }

    record Feature(boolean enabled, int version, Profile.FeatureUpdatePolicy updatePolicy) {
        static Feature from(Profile.Feature feature) {
            return new Feature(Profile.isFeatureEnabled((Profile.Feature)feature), feature.getVersion(), feature.getUpdatePolicy());
        }
    }
}

