/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.infinispan;

import java.io.Writer;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.commons.configuration.io.ConfigurationWriter;
import org.infinispan.commons.io.StringBuilderWriter;
import org.infinispan.commons.util.Version;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.health.CacheHealth;
import org.infinispan.manager.CacheManagerInfo;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.cluster.ClusterProvider;
import org.keycloak.connections.infinispan.DefaultInfinispanConnectionProvider;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.connections.infinispan.InfinispanConnectionProviderFactory;
import org.keycloak.connections.infinispan.InfinispanUtil;
import org.keycloak.connections.infinispan.TopologyInfo;
import org.keycloak.connections.infinispan.remote.RemoteInfinispanConnectionProvider;
import org.keycloak.infinispan.health.ClusterHealth;
import org.keycloak.infinispan.util.InfinispanUtils;
import org.keycloak.marshalling.KeycloakIndexSchemaUtil;
import org.keycloak.marshalling.KeycloakModelSchema;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.cache.infinispan.ClearCacheEvent;
import org.keycloak.models.cache.infinispan.events.RealmRemovedEvent;
import org.keycloak.models.cache.infinispan.events.RealmUpdatedEvent;
import org.keycloak.models.sessions.infinispan.query.ClientSessionQueries;
import org.keycloak.models.sessions.infinispan.query.UserSessionQueries;
import org.keycloak.models.sessions.infinispan.remote.RemoteInfinispanAuthenticationSessionProviderFactory;
import org.keycloak.models.sessions.infinispan.remote.RemoteUserLoginFailureProviderFactory;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.PostMigrationEvent;
import org.keycloak.provider.InvalidationHandler;
import org.keycloak.provider.Provider;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.provider.ProviderEventListener;
import org.keycloak.provider.ServerInfoAwareProviderFactory;
import org.keycloak.spi.infinispan.CacheEmbeddedConfigProvider;
import org.keycloak.spi.infinispan.CacheRemoteConfigProvider;
import org.keycloak.spi.infinispan.impl.embedded.CacheConfigurator;

public class DefaultInfinispanConnectionProviderFactory
implements InfinispanConnectionProviderFactory,
ProviderEventListener,
ServerInfoAwareProviderFactory {
    private static final ReadWriteLock READ_WRITE_LOCK = new ReentrantReadWriteLock();
    private static final Logger logger = Logger.getLogger(DefaultInfinispanConnectionProviderFactory.class);
    private Config.Scope config;
    private volatile EmbeddedCacheManager cacheManager;
    private volatile RemoteCacheManager remoteCacheManager;
    private volatile InfinispanConnectionProvider connectionProvider;
    private volatile ClusterHealth clusterHealth;

    public InfinispanConnectionProvider create(KeycloakSession session) {
        return this.lazyInit(session);
    }

    public static void runWithReadLockOnCacheManager(Runnable task) {
        Lock lock = READ_WRITE_LOCK.readLock();
        lock.lock();
        try {
            task.run();
        }
        finally {
            lock.unlock();
        }
    }

    public static void runWithWriteLockOnCacheManager(Runnable task) {
        Lock lock = READ_WRITE_LOCK.writeLock();
        lock.lock();
        try {
            task.run();
        }
        finally {
            lock.unlock();
        }
    }

    public void close() {
        logger.debug((Object)"Closing provider");
        DefaultInfinispanConnectionProviderFactory.runWithWriteLockOnCacheManager(() -> {
            if (this.cacheManager != null) {
                this.cacheManager.stop();
                this.cacheManager = null;
            }
        });
        if (this.remoteCacheManager != null) {
            this.remoteCacheManager.close();
            this.remoteCacheManager = null;
        }
    }

    public String getId() {
        return "default";
    }

    public void init(Config.Scope config) {
        this.config = config;
    }

    public void postInit(KeycloakSessionFactory factory) {
        factory.register((ProviderEventListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InfinispanConnectionProvider lazyInit(KeycloakSession keycloakSession) {
        if (this.connectionProvider != null) {
            return this.connectionProvider;
        }
        DefaultInfinispanConnectionProviderFactory defaultInfinispanConnectionProviderFactory = this;
        synchronized (defaultInfinispanConnectionProviderFactory) {
            if (this.connectionProvider != null) {
                return this.connectionProvider;
            }
            this.cacheManager = this.createEmbeddedCacheManager(keycloakSession);
            this.injectKeycloakTimeService(this.cacheManager);
            TopologyInfo topologyInfo = new TopologyInfo(this.cacheManager);
            logger.infof(topologyInfo.toString(), new Object[0]);
            this.remoteCacheManager = this.createRemoteCacheManager(keycloakSession);
            this.connectionProvider = InfinispanUtils.isRemoteInfinispan() ? new RemoteInfinispanConnectionProvider(this.cacheManager, this.remoteCacheManager, topologyInfo) : new DefaultInfinispanConnectionProvider(this.cacheManager, topologyInfo);
            this.clusterHealth = (ClusterHealth)GlobalComponentRegistry.componentOf((EmbeddedCacheManager)this.cacheManager, ClusterHealth.class);
            return this.connectionProvider;
        }
    }

    protected EmbeddedCacheManager createEmbeddedCacheManager(KeycloakSession session) {
        ConfigurationBuilderHolder holder = ((CacheEmbeddedConfigProvider)session.getProvider(CacheEmbeddedConfigProvider.class)).configuration();
        StringBuilderWriter sw = new StringBuilderWriter();
        ParserRegistry parser = new ParserRegistry();
        try (ConfigurationWriter w = ConfigurationWriter.to((Writer)sw).prettyPrint(true).build();){
            GlobalConfiguration globalConfig = holder.getGlobalConfigurationBuilder().build();
            Map<String, Configuration> cacheConfigs = holder.getNamedConfigurationBuilders().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((ConfigurationBuilder)e.getValue()).build()));
            parser.serialize(w, globalConfig, cacheConfigs);
            logger.debugf("Infinispan configuration:\n%s", (Object)sw);
        }
        DefaultCacheManager cm = new DefaultCacheManager(holder, true);
        cm.getCache("keys", true);
        cm.getCache("crl", true);
        logger.debugv("Using container managed Infinispan cache container, lookup={0}", (Object)cm);
        return cm;
    }

    protected RemoteCacheManager createRemoteCacheManager(KeycloakSession session) {
        Optional<org.infinispan.client.hotrod.configuration.Configuration> remoteConfig = ((CacheRemoteConfigProvider)session.getProvider(CacheRemoteConfigProvider.class)).configuration();
        if (remoteConfig.isEmpty()) {
            logger.debug((Object)"Remote Cache feature is disabled");
            return null;
        }
        logger.debug((Object)"Remote Cache feature is enabled");
        RemoteCacheManager rcm = new RemoteCacheManager(remoteConfig.get());
        List<KeycloakIndexSchemaUtil.IndexedEntity> entities = List.of(new KeycloakIndexSchemaUtil.IndexedEntity(RemoteUserLoginFailureProviderFactory.PROTO_ENTITY, "loginFailures"), new KeycloakIndexSchemaUtil.IndexedEntity(RemoteInfinispanAuthenticationSessionProviderFactory.PROTO_ENTITY, "authenticationSessions"), new KeycloakIndexSchemaUtil.IndexedEntity(ClientSessionQueries.CLIENT_SESSION, "clientSessions"), new KeycloakIndexSchemaUtil.IndexedEntity(ClientSessionQueries.CLIENT_SESSION, "offlineClientSessions"), new KeycloakIndexSchemaUtil.IndexedEntity(UserSessionQueries.USER_SESSION, "sessions"), new KeycloakIndexSchemaUtil.IndexedEntity(UserSessionQueries.USER_SESSION, "offlineSessions"));
        KeycloakIndexSchemaUtil.uploadAndReindexCaches(rcm, KeycloakModelSchema.INSTANCE, entities);
        return rcm;
    }

    @Deprecated(since="26.0", forRemoval=true)
    protected EmbeddedCacheManager initContainerManaged(EmbeddedCacheManager cacheManager) {
        throw new UnsupportedOperationException();
    }

    @Deprecated(since="26.3", forRemoval=true)
    protected EmbeddedCacheManager initEmbedded() {
        throw new UnsupportedOperationException();
    }

    @Deprecated(since="26.3", forRemoval=true)
    protected Configuration getKeysCacheConfig() {
        return CacheConfigurator.getCacheConfiguration("keys", true).build();
    }

    @Deprecated(since="26.3", forRemoval=true)
    protected Configuration getCrlCacheConfig() {
        return CacheConfigurator.getCrlCacheConfig().build();
    }

    private void registerSystemWideListeners(KeycloakSession session) {
        KeycloakSessionFactory sessionFactory = session.getKeycloakSessionFactory();
        ClusterProvider cluster = (ClusterProvider)session.getProvider(ClusterProvider.class);
        cluster.registerListener("REALM_CLEAR_CACHE_EVENTS", event -> {
            if (event instanceof ClearCacheEvent) {
                sessionFactory.invalidate(null, (InvalidationHandler.InvalidableObjectType)InvalidationHandler.ObjectType._ALL_, new Object[0]);
            }
        });
        cluster.registerListener("REALM_INVALIDATION_EVENTS", event -> {
            if (event instanceof RealmUpdatedEvent) {
                RealmUpdatedEvent rr = (RealmUpdatedEvent)event;
                sessionFactory.invalidate(null, (InvalidationHandler.InvalidableObjectType)InvalidationHandler.ObjectType.REALM, new Object[]{rr.getId()});
            } else if (event instanceof RealmRemovedEvent) {
                RealmRemovedEvent rr = (RealmRemovedEvent)event;
                sessionFactory.invalidate(null, (InvalidationHandler.InvalidableObjectType)InvalidationHandler.ObjectType.REALM, new Object[]{rr.getId()});
            }
        });
    }

    private void injectKeycloakTimeService(EmbeddedCacheManager cacheManager) {
        if (this.config.getBoolean("useKeycloakTimeService", Boolean.FALSE).booleanValue()) {
            InfinispanUtil.setTimeServiceToKeycloakTime(cacheManager);
        }
    }

    public Set<Class<? extends Provider>> dependsOn() {
        return Set.of(CacheRemoteConfigProvider.class, CacheEmbeddedConfigProvider.class);
    }

    public void onEvent(ProviderEvent event) {
        if (event instanceof PostMigrationEvent) {
            PostMigrationEvent pme = (PostMigrationEvent)event;
            KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)pme.getFactory(), this::registerSystemWideListeners);
        }
    }

    public Map<String, String> getOperationalInfo() {
        LinkedHashMap<String, String> info = new LinkedHashMap<String, String>();
        info.put("product", Version.getBrandName());
        info.put("version", Version.getBrandVersion());
        if (InfinispanUtils.isRemoteInfinispan()) {
            this.addRemoteOperationalInfo(info);
        } else {
            this.addEmbeddedOperationalInfo(info);
        }
        return info;
    }

    @Override
    public boolean isClusterHealthy() {
        this.clusterHealth.triggerClusterHealthCheck();
        return this.clusterHealth.isHealthy();
    }

    @Override
    public boolean isClusterHealthSupported() {
        return this.clusterHealth.isSupported();
    }

    private void addEmbeddedOperationalInfo(Map<String, String> info) {
        CacheManagerInfo cacheManagerInfo = this.cacheManager.getCacheManagerInfo();
        info.put("clusterSize", Integer.toString(cacheManagerInfo.getClusterSize()));
        LinkedHashSet cacheNames = Arrays.stream(InfinispanConnectionProvider.CLUSTERED_CACHE_NAMES).sorted().collect(Collectors.toCollection(LinkedHashSet::new));
        for (CacheHealth health : this.cacheManager.getHealth().getCacheHealth((Set)cacheNames)) {
            info.put(health.getCacheName() + ":Cache", health.getStatus().toString());
        }
    }

    private void addRemoteOperationalInfo(Map<String, String> info) {
        info.put("connectionCount", Integer.toString(this.remoteCacheManager.getConnectionCount()));
    }
}

