/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.verifier.internal.asn1;

import com.webauthn4j.verifier.internal.asn1.ASN1;
import com.webauthn4j.verifier.internal.asn1.ASN1Length;
import com.webauthn4j.verifier.internal.asn1.ASN1Primitive;
import com.webauthn4j.verifier.internal.asn1.ASN1Tag;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ASN1Structure
extends ASN1
implements Iterable<ASN1> {
    private final List<ASN1> value;

    public static ASN1Structure parse(byte[] bytes) {
        return ASN1Structure.parse(ByteBuffer.wrap(bytes));
    }

    public static ASN1Structure parse(ByteBuffer byteBuffer) {
        ASN1Tag tag = ASN1Tag.parse(byteBuffer);
        ASN1Length length = ASN1Length.parse(byteBuffer);
        if (tag.isConstructed()) {
            List<ASN1> value = ASN1Structure.parseValue(byteBuffer, length);
            return new ASN1Structure(tag, length, value);
        }
        throw new IllegalArgumentException("primitive data is provided");
    }

    static List<ASN1> parseValue(ByteBuffer byteBuffer, ASN1Length length) {
        int newObjLength;
        ArrayList<ASN1> res = new ArrayList<ASN1>();
        int valueLength = length.getValueLength();
        for (int readLength = 0; readLength < valueLength; readLength += newObjLength) {
            int beforePos = byteBuffer.position();
            ASN1 newObj = ASN1Structure.parseChild(byteBuffer);
            int afterPos = byteBuffer.position();
            newObjLength = afterPos - beforePos;
            if (newObj.getTag().getTagClass() == ASN1Tag.ASN1TagClass.UNIVERSAL && !newObj.getTag().isConstructed() && newObj.getTag().getNumber() == 0 && newObj.getLength().getValueLength() == 0) break;
            res.add(newObj);
        }
        return res;
    }

    static ASN1 parseChild(ByteBuffer byteBuffer) {
        ASN1Tag tag = ASN1Tag.parse(byteBuffer);
        ASN1Length length = ASN1Length.parse(byteBuffer);
        if (tag.isConstructed()) {
            List<ASN1> value = ASN1Structure.parseValue(byteBuffer, length);
            return new ASN1Structure(tag, length, value);
        }
        byte[] value = ASN1Primitive.parseValue(byteBuffer, length);
        return new ASN1Primitive(tag, length, value);
    }

    public ASN1Structure(ASN1Tag tag, ASN1Length length, List<ASN1> value) {
        super(tag, length);
        this.value = value;
    }

    public ASN1 get(int index) {
        return this.value.get(index);
    }

    public int size() {
        return this.value.size();
    }

    @Override
    @NotNull
    public Iterator<ASN1> iterator() {
        return this.value.iterator();
    }
}

