/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.verifier.attestation.statement;

import com.webauthn4j.data.SignatureAlgorithm;
import com.webauthn4j.data.attestation.statement.AttestationStatement;
import com.webauthn4j.data.attestation.statement.COSEAlgorithmIdentifier;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.verifier.CoreRegistrationObject;
import com.webauthn4j.verifier.attestation.statement.AttestationStatementVerifier;
import com.webauthn4j.verifier.exception.BadAttestationStatementException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractStatementVerifier<T extends AttestationStatement>
implements AttestationStatementVerifier {
    private final Class<?> parameterizedTypeClass;

    protected AbstractStatementVerifier() {
        ParameterizedType parameterizedType = (ParameterizedType)this.getClass().getGenericSuperclass();
        if (parameterizedType.getActualTypeArguments().length == 0) {
            throw new IllegalStateException("Inheriting class must extend AttestationStatement");
        }
        Type actualTypeArgument = parameterizedType.getActualTypeArguments()[0];
        if (!(actualTypeArgument instanceof Class)) {
            throw new IllegalStateException("Inheriting class must extend AttestationStatement");
        }
        this.parameterizedTypeClass = (Class)actualTypeArgument;
    }

    @Override
    public boolean supports(@NotNull CoreRegistrationObject registrationObject) {
        AssertUtil.notNull(registrationObject, "registrationObject must not be null");
        AttestationStatement attestationStatement = registrationObject.getAttestationObject().getAttestationStatement();
        if (attestationStatement == null) {
            return false;
        }
        return this.parameterizedTypeClass.isAssignableFrom(attestationStatement.getClass());
    }

    protected String getJcaName(@NotNull COSEAlgorithmIdentifier alg) {
        String jcaName;
        try {
            SignatureAlgorithm signatureAlgorithm = alg.toSignatureAlgorithm();
            jcaName = signatureAlgorithm.getJcaName();
        }
        catch (IllegalArgumentException e) {
            throw new BadAttestationStatementException("alg is not signature algorithm", e);
        }
        return jcaName;
    }
}

