/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.extension;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.webauthn4j.util.ArrayUtil;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HMACGetSecretOutput {
    @JsonProperty
    private final byte[] output1;
    @JsonProperty
    private final byte[] output2;

    @JsonCreator
    public HMACGetSecretOutput(@JsonProperty(value="output1") @NotNull byte[] output1, @JsonProperty(value="output2") @Nullable byte[] output2) {
        this.output1 = ArrayUtil.clone(output1);
        this.output2 = ArrayUtil.clone(output2);
    }

    public HMACGetSecretOutput(@NotNull byte[] output1) {
        this.output1 = ArrayUtil.clone(output1);
        this.output2 = null;
    }

    @NotNull
    public byte[] getOutput1() {
        return ArrayUtil.clone(this.output1);
    }

    @Nullable
    public byte[] getOutput2() {
        return ArrayUtil.clone(this.output2);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HMACGetSecretOutput that = (HMACGetSecretOutput)o;
        return Arrays.equals(this.output1, that.output1) && Arrays.equals(this.output2, that.output2);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.output1);
        result = 31 * result + Arrays.hashCode(this.output2);
        return result;
    }
}

