/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.impl;

import java.util.Collection;
import org.infinispan.query.dsl.Expression;
import org.infinispan.query.dsl.FilterConditionEndContext;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.RangeConditionContextQueryBuilder;
import org.infinispan.query.dsl.impl.BaseCondition;
import org.infinispan.query.dsl.impl.BetweenOperator;
import org.infinispan.query.dsl.impl.ContainsAllOperator;
import org.infinispan.query.dsl.impl.ContainsAnyOperator;
import org.infinispan.query.dsl.impl.ContainsOperator;
import org.infinispan.query.dsl.impl.EqOperator;
import org.infinispan.query.dsl.impl.GtOperator;
import org.infinispan.query.dsl.impl.GteOperator;
import org.infinispan.query.dsl.impl.InOperator;
import org.infinispan.query.dsl.impl.IsNullOperator;
import org.infinispan.query.dsl.impl.LikeOperator;
import org.infinispan.query.dsl.impl.LtOperator;
import org.infinispan.query.dsl.impl.LteOperator;
import org.infinispan.query.dsl.impl.OperatorAndArgument;
import org.infinispan.query.dsl.impl.ValueRange;
import org.infinispan.query.dsl.impl.Visitor;
import org.infinispan.query.dsl.impl.logging.Log;
import org.jboss.logging.Logger;

final class AttributeCondition
extends BaseCondition
implements FilterConditionEndContext,
RangeConditionContextQueryBuilder {
    private static final Log log = (Log)Logger.getMessageLogger(Log.class, (String)AttributeCondition.class.getName());
    private final Expression expression;
    private boolean isNegated;
    private OperatorAndArgument operatorAndArgument;

    public AttributeCondition(QueryFactory queryFactory, Expression expression) {
        super(queryFactory);
        this.expression = expression;
    }

    OperatorAndArgument getOperatorAndArgument() {
        return this.operatorAndArgument;
    }

    Expression getExpression() {
        return this.expression;
    }

    boolean isNegated() {
        return this.isNegated;
    }

    void setNegated(boolean negated) {
        this.isNegated = negated;
    }

    @Override
    public BaseCondition in(Object ... values) {
        if (values == null || values.length == 0) {
            throw log.listOfValuesForInCannotBeNulOrEmpty();
        }
        this.setOperatorAndArgument(new InOperator(this, values));
        return this;
    }

    @Override
    public BaseCondition in(Collection values) {
        if (values == null || values.isEmpty()) {
            throw log.listOfValuesForInCannotBeNulOrEmpty();
        }
        this.setOperatorAndArgument(new InOperator(this, values));
        return this;
    }

    @Override
    public BaseCondition like(String pattern) {
        this.setOperatorAndArgument(new LikeOperator(this, pattern));
        return this;
    }

    @Override
    public BaseCondition contains(Object value) {
        this.setOperatorAndArgument(new ContainsOperator(this, value));
        return this;
    }

    @Override
    public BaseCondition containsAll(Object ... values) {
        this.setOperatorAndArgument(new ContainsAllOperator(this, values));
        return this;
    }

    @Override
    public BaseCondition containsAll(Collection values) {
        this.setOperatorAndArgument(new ContainsAllOperator(this, values));
        return this;
    }

    @Override
    public BaseCondition containsAny(Object ... values) {
        this.setOperatorAndArgument(new ContainsAnyOperator(this, values));
        return this;
    }

    @Override
    public BaseCondition containsAny(Collection values) {
        this.setOperatorAndArgument(new ContainsAnyOperator(this, values));
        return this;
    }

    @Override
    public BaseCondition isNull() {
        this.setOperatorAndArgument(new IsNullOperator(this));
        return this;
    }

    public BaseCondition eq(Object value) {
        this.setOperatorAndArgument(new EqOperator(this, value));
        return this;
    }

    @Override
    public BaseCondition equal(Object value) {
        return this.eq(value);
    }

    @Override
    public BaseCondition lt(Object value) {
        this.setOperatorAndArgument(new LtOperator(this, value));
        return this;
    }

    @Override
    public BaseCondition lte(Object value) {
        this.setOperatorAndArgument(new LteOperator(this, value));
        return this;
    }

    @Override
    public BaseCondition gt(Object value) {
        this.setOperatorAndArgument(new GtOperator(this, value));
        return this;
    }

    @Override
    public BaseCondition gte(Object value) {
        this.setOperatorAndArgument(new GteOperator(this, value));
        return this;
    }

    @Override
    public AttributeCondition between(Object from, Object to) {
        this.setOperatorAndArgument(new BetweenOperator(this, new ValueRange(from, to)));
        return this;
    }

    @Override
    public AttributeCondition includeLower(boolean includeLower) {
        ValueRange valueRange = (ValueRange)this.operatorAndArgument.getArgument();
        valueRange.setIncludeLower(includeLower);
        return this;
    }

    @Override
    public AttributeCondition includeUpper(boolean includeUpper) {
        ValueRange valueRange = (ValueRange)this.operatorAndArgument.getArgument();
        valueRange.setIncludeUpper(includeUpper);
        return this;
    }

    private void setOperatorAndArgument(OperatorAndArgument operatorAndArgument) {
        operatorAndArgument.validate();
        if (this.operatorAndArgument != null) {
            throw log.operatorWasAlreadySpecified();
        }
        this.operatorAndArgument = operatorAndArgument;
    }

    @Override
    public <ReturnType> ReturnType accept(Visitor<ReturnType> visitor) {
        return visitor.visit(this);
    }

    public String toString() {
        return "AttributeCondition{isNegated=" + this.isNegated + ", expression='" + String.valueOf(this.expression) + "', operatorAndArgument=" + String.valueOf(this.operatorAndArgument) + "}";
    }
}

