/*
 * Decompiled with CFR 0.152.
 */
package liquibase.integration.ant;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import liquibase.Contexts;
import liquibase.Liquibase;
import liquibase.exception.LiquibaseException;
import liquibase.integration.ant.AbstractChangeLogBasedTask;
import lombok.Generated;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.util.FileUtils;

public class ChangeLogSyncTask
extends AbstractChangeLogBasedTask {
    private String toTag;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void executeWithLiquibaseClassloader() throws BuildException {
        Liquibase liquibase = this.getLiquibase();
        OutputStreamWriter writer = null;
        try {
            FileResource outputFile = this.getOutputFile();
            if (outputFile != null) {
                writer = new OutputStreamWriter(outputFile.getOutputStream(), this.getOutputEncoding());
                liquibase.changeLogSync(this.toTag, new Contexts(this.getContexts()), this.getLabelFilter(), writer);
            } else {
                liquibase.changeLogSync(this.toTag, new Contexts(this.getContexts()), this.getLabelFilter());
            }
        }
        catch (UnsupportedEncodingException e) {
            try {
                throw new BuildException("Unable to generate sync SQL. Encoding [" + this.getOutputEncoding() + "] is not supported.", (Throwable)e);
                catch (IOException e2) {
                    throw new BuildException("Unable to generate sync SQL. Error creating output writer.", (Throwable)e2);
                }
                catch (LiquibaseException e3) {
                    throw new BuildException("Unable to sync change log: " + e3.getMessage(), (Throwable)e3);
                }
            }
            catch (Throwable throwable) {
                FileUtils.close(writer);
                throw throwable;
            }
        }
        FileUtils.close((Writer)writer);
    }

    @Generated
    public String getToTag() {
        return this.toTag;
    }

    @Generated
    public void setToTag(String toTag) {
        this.toTag = toTag;
    }
}

