/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.quarkus.hibernate.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.LongSupplier;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.engine.spi.SessionImplementor;
import org.infinispan.quarkus.hibernate.cache.InternalCache;
import org.jboss.logging.Logger;

final class PutFromLoadValidator {
    static final Logger log = Logger.getLogger(PutFromLoadValidator.class);
    static final boolean trace = log.isTraceEnabled();
    static final long EXPIRATION_PERIOD = Duration.ofSeconds(60L).toMillis();
    private final Cache<Object, PendingPutMap> pendingPuts;
    final InternalCache cache;
    final LongSupplier nextTimestamp;
    private final String regionName;
    private volatile long regionInvalidationTimestamp = Long.MIN_VALUE;
    private int regionInvalidations = 0;

    public PutFromLoadValidator(InternalCache cache, String regionName, RegionFactory regionFactory) {
        this.cache = cache;
        this.regionName = regionName;
        this.nextTimestamp = () -> ((RegionFactory)regionFactory).nextTimestamp();
        this.pendingPuts = Caffeine.newBuilder().executor(Runnable::run).expireAfterAccess(Duration.ofMillis(EXPIRATION_PERIOD)).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Lock acquirePutFromLoadLock(Object session, Object key, long txTimestamp) {
        if (trace) {
            log.tracef("acquirePutFromLoadLock(%s#%s, %d)", (Object)this.regionName, key, (Object)txTimestamp);
        }
        boolean locked = false;
        PendingPutMap pending = (PendingPutMap)this.pendingPuts.getIfPresent(key);
        try {
            while (true) {
                if (pending != null) {
                    locked = pending.acquireLock(100L, TimeUnit.MILLISECONDS);
                    if (locked) {
                        PendingPutMap pendingPutMap;
                        block23: {
                            boolean valid;
                            block22: {
                                valid = false;
                                try {
                                    if (!pending.isRemoved()) break block22;
                                    pending.releaseLock();
                                    locked = false;
                                    pending = null;
                                    if (trace) {
                                        log.tracef("Record removed when waiting for the lock.", new Object[0]);
                                    }
                                    if (!valid && pending != null) {
                                        pending.releaseLock();
                                        locked = false;
                                    }
                                    if (!trace) continue;
                                }
                                catch (Throwable throwable) {
                                    if (!valid && pending != null) {
                                        pending.releaseLock();
                                        locked = false;
                                    }
                                    if (trace) {
                                        log.tracef("acquirePutFromLoadLock(%s#%s, %d) ended with %s, valid: %s", new Object[]{this.regionName, key, txTimestamp, pending, valid});
                                    }
                                    throw throwable;
                                }
                                log.tracef("acquirePutFromLoadLock(%s#%s, %d) ended with %s, valid: %s", new Object[]{this.regionName, key, txTimestamp, pending, valid});
                                continue;
                            }
                            PendingPut toCancel = pending.remove(session);
                            if (toCancel != null) {
                                valid = !toCancel.completed;
                                toCancel.completed = true;
                            } else {
                                valid = pending.hasInvalidator() ? false : (pending.lastInvalidationEnd != Long.MIN_VALUE ? txTimestamp > pending.lastInvalidationEnd : txTimestamp > this.regionInvalidationTimestamp);
                            }
                            PendingPutMap pendingPutMap2 = pendingPutMap = valid ? pending : null;
                            if (!valid && pending != null) {
                                pending.releaseLock();
                                locked = false;
                            }
                            if (!trace) break block23;
                            log.tracef("acquirePutFromLoadLock(%s#%s, %d) ended with %s, valid: %s", new Object[]{this.regionName, key, txTimestamp, pending, valid});
                        }
                        return pendingPutMap;
                    }
                    if (trace) {
                        log.tracef("acquirePutFromLoadLock(%s#%s, %d) failed to lock", (Object)this.regionName, key, (Object)txTimestamp);
                    }
                    return null;
                }
                long regionInvalidationTimestamp = this.regionInvalidationTimestamp;
                if (txTimestamp <= regionInvalidationTimestamp) {
                    if (trace) {
                        log.tracef("acquirePutFromLoadLock(%s#%s, %d) failed due to region invalidated at %d", new Object[]{this.regionName, key, txTimestamp, regionInvalidationTimestamp});
                    }
                    return null;
                }
                if (trace) {
                    log.tracef("Region invalidated at %d, this transaction started at %d", regionInvalidationTimestamp, txTimestamp);
                }
                PendingPut pendingPut = new PendingPut(session);
                pending = new PendingPutMap(pendingPut);
                PendingPutMap existing = this.pendingPuts.asMap().putIfAbsent(key, pending);
                if (existing == null) continue;
                pending = existing;
            }
        }
        catch (Throwable t) {
            if (locked) {
                pending.releaseLock();
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw (Error)t;
        }
    }

    public void releasePutFromLoadLock(Object key, Lock lock) {
        PendingPutMap pending;
        if (trace) {
            log.tracef("releasePutFromLoadLock(%s#%s, %s)", (Object)this.regionName, key, (Object)lock);
        }
        if ((pending = (PendingPutMap)lock) != null) {
            if (pending.canRemove()) {
                pending.setRemoved();
                this.pendingPuts.asMap().remove(key, pending);
            }
            pending.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean beginInvalidatingRegion() {
        if (trace) {
            log.trace((Object)("Started invalidating region " + this.regionName));
        }
        boolean ok = true;
        long now = this.nextTimestamp.getAsLong();
        PutFromLoadValidator putFromLoadValidator = this;
        synchronized (putFromLoadValidator) {
            this.regionInvalidationTimestamp = Long.MAX_VALUE;
            ++this.regionInvalidations;
        }
        try {
            for (PendingPutMap entry : this.pendingPuts.asMap().values()) {
                if (entry.acquireLock(60L, TimeUnit.SECONDS)) {
                    try {
                        entry.invalidate(now);
                        continue;
                    }
                    finally {
                        entry.releaseLock();
                        continue;
                    }
                }
                ok = false;
            }
        }
        catch (Exception e) {
            ok = false;
        }
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endInvalidatingRegion() {
        PutFromLoadValidator putFromLoadValidator = this;
        synchronized (putFromLoadValidator) {
            if (--this.regionInvalidations == 0) {
                this.regionInvalidationTimestamp = this.nextTimestamp.getAsLong();
                if (trace) {
                    log.tracef("Finished invalidating region %s at %d", (Object)this.regionName, (Object)this.regionInvalidationTimestamp);
                }
            } else if (trace) {
                log.tracef("Finished invalidating region %s, but there are %d ongoing invalidations", (Object)this.regionName, (Object)this.regionInvalidations);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPendingPut(Object session, Object key, long txTimestamp) {
        block13: {
            PendingPutMap existing;
            long invalidationTimestamp = this.regionInvalidationTimestamp;
            if (txTimestamp <= invalidationTimestamp) {
                if (trace) {
                    log.tracef("registerPendingPut(%s#%s, %d) skipped due to region invalidation (%d)", new Object[]{this.regionName, key, txTimestamp, invalidationTimestamp});
                }
                return;
            }
            PendingPut pendingPut = new PendingPut(session);
            PendingPutMap pendingForKey = new PendingPutMap(pendingPut);
            while ((existing = this.pendingPuts.asMap().putIfAbsent(key, pendingForKey)) != null) {
                if (existing.acquireLock(10L, TimeUnit.SECONDS)) {
                    block12: {
                        try {
                            if (existing.isRemoved()) {
                                if (!trace) continue;
                                log.tracef("Record removed when waiting for the lock.", new Object[0]);
                                continue;
                            }
                            if (existing.hasInvalidator()) break block12;
                            existing.put(pendingPut);
                        }
                        finally {
                            existing.releaseLock();
                            continue;
                        }
                    }
                    if (trace) {
                        log.tracef("registerPendingPut(%s#%s, %d) ended with %s", new Object[]{this.regionName, key, txTimestamp, existing});
                    }
                    break block13;
                }
                if (trace) {
                    log.tracef("registerPendingPut(%s#%s, %d) failed to acquire lock", (Object)this.regionName, key, (Object)txTimestamp);
                }
                break block13;
            }
            if (trace) {
                log.tracef("registerPendingPut(%s#%s, %d) registered using putIfAbsent: %s", new Object[]{this.regionName, key, txTimestamp, pendingForKey});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean beginInvalidatingWithPFER(Object lockOwner, Object key, Object valueForPFER) {
        block9: {
            PendingPutMap pending;
            while (true) {
                pending = new PendingPutMap(null);
                PendingPutMap prev = this.pendingPuts.asMap().putIfAbsent(key, pending);
                if (prev != null) {
                    pending = prev;
                }
                if (!pending.acquireLock(60L, TimeUnit.SECONDS)) break block9;
                try {
                    if (pending.isRemoved()) {
                        if (!trace) continue;
                        log.tracef("Record removed when waiting for the lock.", new Object[0]);
                        continue;
                    }
                    long now = this.nextTimestamp.getAsLong();
                    if (trace) {
                        log.tracef("beginInvalidatingKey(%s#%s, %s) remove invalidator from %s", new Object[]{this.regionName, key, PutFromLoadValidator.lockOwnerToString(lockOwner), pending});
                    }
                    pending.invalidate(now);
                    pending.addInvalidator(lockOwner, valueForPFER, now);
                }
                finally {
                    pending.releaseLock();
                    continue;
                }
                break;
            }
            if (trace) {
                log.tracef("beginInvalidatingKey(%s#%s, %s) ends with %s", new Object[]{this.regionName, key, PutFromLoadValidator.lockOwnerToString(lockOwner), pending});
            }
            return true;
        }
        log.tracef("beginInvalidatingKey(%s#%s, %s) failed to acquire lock", (Object)this.regionName, key, (Object)PutFromLoadValidator.lockOwnerToString(lockOwner));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean endInvalidatingKey(Object lockOwner, Object key, boolean doPFER) {
        PendingPutMap pending = (PendingPutMap)this.pendingPuts.getIfPresent(key);
        if (pending == null) {
            if (trace) {
                log.tracef("endInvalidatingKey(%s#%s, %s) could not find pending puts", (Object)this.regionName, key, (Object)PutFromLoadValidator.lockOwnerToString(lockOwner));
            }
            return true;
        }
        if (pending.acquireLock(60L, TimeUnit.SECONDS)) {
            boolean bl;
            block7: {
                try {
                    long now = this.nextTimestamp.getAsLong();
                    pending.removeInvalidator(lockOwner, key, now, doPFER);
                    bl = true;
                    pending.releaseLock();
                    if (!trace) break block7;
                }
                catch (Throwable throwable) {
                    pending.releaseLock();
                    if (trace) {
                        log.tracef("endInvalidatingKey(%s#%s, %s) ends with %s", new Object[]{this.regionName, key, PutFromLoadValidator.lockOwnerToString(lockOwner), pending});
                    }
                    throw throwable;
                }
                log.tracef("endInvalidatingKey(%s#%s, %s) ends with %s", new Object[]{this.regionName, key, PutFromLoadValidator.lockOwnerToString(lockOwner), pending});
            }
            return bl;
        }
        if (trace) {
            log.tracef("endInvalidatingKey(%s#%s, %s) failed to acquire lock", (Object)this.regionName, key, (Object)PutFromLoadValidator.lockOwnerToString(lockOwner));
        }
        return false;
    }

    static String lockOwnerToString(Object lockOwner) {
        return lockOwner instanceof SessionImplementor ? "Session#" + lockOwner.hashCode() : lockOwner.toString();
    }

    public void removePendingPutsCache() {
        this.pendingPuts.invalidateAll();
    }

    private class PendingPutMap
    extends Lock {
        private static final int GC_THRESHOLD = 10;
        private PendingPut singlePendingPut;
        private Map<Object, PendingPut> fullMap;
        private final java.util.concurrent.locks.Lock lock;
        private Invalidator singleInvalidator;
        private Map<Object, Invalidator> invalidators;
        long lastInvalidationEnd;
        private boolean removed;

        PendingPutMap(PendingPut singleItem) {
            this.lock = new ReentrantLock();
            this.lastInvalidationEnd = Long.MIN_VALUE;
            this.removed = false;
            this.singlePendingPut = singleItem;
        }

        public String toString() {
            if (this.lock.tryLock()) {
                try {
                    StringBuilder sb = new StringBuilder();
                    sb.append("{ PendingPuts=");
                    if (this.singlePendingPut == null) {
                        if (this.fullMap == null) {
                            sb.append("[]");
                        } else {
                            sb.append(this.fullMap.values());
                        }
                    } else {
                        sb.append('[').append(this.singlePendingPut).append(']');
                    }
                    sb.append(", Invalidators=");
                    if (this.singleInvalidator == null) {
                        if (this.invalidators == null) {
                            sb.append("[]");
                        } else {
                            sb.append(this.invalidators.values());
                        }
                    } else {
                        sb.append('[').append(this.singleInvalidator).append(']');
                    }
                    sb.append(", LastInvalidationEnd=");
                    if (this.lastInvalidationEnd == Long.MIN_VALUE) {
                        sb.append("<none>");
                    } else {
                        sb.append(this.lastInvalidationEnd);
                    }
                    String string = sb.append(", Removed=").append(this.removed).append("}").toString();
                    return string;
                }
                finally {
                    this.lock.unlock();
                }
            }
            return "PendingPutMap: <locked>";
        }

        public void put(PendingPut pendingPut) {
            if (this.singlePendingPut == null) {
                if (this.fullMap == null) {
                    this.singlePendingPut = pendingPut;
                } else {
                    this.fullMap.put(pendingPut.owner, pendingPut);
                    if (this.fullMap.size() >= 10) {
                        this.gc();
                    }
                }
            } else {
                this.fullMap = new HashMap<Object, PendingPut>(4);
                this.fullMap.put(this.singlePendingPut.owner, this.singlePendingPut);
                this.singlePendingPut = null;
                this.fullMap.put(pendingPut.owner, pendingPut);
            }
        }

        public PendingPut remove(Object ownerForPut) {
            PendingPut removed = null;
            if (this.fullMap == null) {
                if (this.singlePendingPut != null && this.singlePendingPut.owner.equals(ownerForPut)) {
                    removed = this.singlePendingPut;
                    this.singlePendingPut = null;
                }
            } else {
                removed = this.fullMap.remove(ownerForPut);
            }
            return removed;
        }

        public int size() {
            return this.fullMap == null ? (this.singlePendingPut == null ? 0 : 1) : this.fullMap.size();
        }

        public boolean acquireLock(long time, TimeUnit unit) {
            try {
                return this.lock.tryLock(time, unit);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        }

        public void releaseLock() {
            this.lock.unlock();
        }

        public void invalidate(long now) {
            if (this.singlePendingPut != null) {
                if (this.singlePendingPut.invalidate(now, EXPIRATION_PERIOD)) {
                    this.singlePendingPut = null;
                }
            } else if (this.fullMap != null) {
                Iterator<PendingPut> it = this.fullMap.values().iterator();
                while (it.hasNext()) {
                    PendingPut pp = it.next();
                    if (!pp.invalidate(now, EXPIRATION_PERIOD)) continue;
                    it.remove();
                }
            }
        }

        private void gc() {
            assert (this.fullMap != null);
            long now = PutFromLoadValidator.this.nextTimestamp.getAsLong();
            log.tracef("Contains %d, doing GC at %d, expiration %d", (long)this.size(), now, EXPIRATION_PERIOD);
            Iterator<PendingPut> it = this.fullMap.values().iterator();
            while (it.hasNext()) {
                PendingPut pp = it.next();
                if (!pp.gc(now, EXPIRATION_PERIOD)) continue;
                it.remove();
            }
        }

        public void addInvalidator(Object owner, Object valueForPFER, long now) {
            assert (owner != null);
            if (this.invalidators == null) {
                if (this.singleInvalidator == null) {
                    this.singleInvalidator = new Invalidator(owner, now, valueForPFER);
                    this.put(new PendingPut(owner));
                } else {
                    if (this.singleInvalidator.registeredTimestamp + EXPIRATION_PERIOD < now) {
                        this.singleInvalidator = new Invalidator(owner, now, valueForPFER);
                        this.put(new PendingPut(owner));
                    }
                    this.invalidators = new HashMap<Object, Invalidator>();
                    this.invalidators.put(this.singleInvalidator.owner, this.singleInvalidator);
                    this.invalidators.put(owner, new Invalidator(owner, now, null));
                    this.singleInvalidator = null;
                }
            } else {
                long allowedRegistration = now - EXPIRATION_PERIOD;
                Iterator<Invalidator> it = this.invalidators.values().iterator();
                while (it.hasNext()) {
                    if (it.next().registeredTimestamp >= allowedRegistration) continue;
                    it.remove();
                }
                if (valueForPFER != null && this.invalidators.isEmpty()) {
                    this.put(new PendingPut(owner));
                } else {
                    valueForPFER = null;
                }
                this.invalidators.put(owner, new Invalidator(owner, now, valueForPFER));
            }
        }

        public boolean hasInvalidator() {
            return this.singleInvalidator != null || this.invalidators != null && !this.invalidators.isEmpty();
        }

        public Collection<Invalidator> getInvalidators() {
            this.lock.lock();
            try {
                if (this.singleInvalidator != null) {
                    Set<Invalidator> set = Collections.singleton(this.singleInvalidator);
                    return set;
                }
                if (this.invalidators != null) {
                    ArrayList<Invalidator> arrayList = new ArrayList<Invalidator>(this.invalidators.values());
                    return arrayList;
                }
                List list = Collections.EMPTY_LIST;
                return list;
            }
            finally {
                this.lock.unlock();
            }
        }

        public void removeInvalidator(Object owner, Object key, long now, boolean doPFER) {
            if (this.invalidators == null) {
                if (this.singleInvalidator != null && this.singleInvalidator.owner.equals(owner)) {
                    this.pferValueIfNeeded(owner, key, this.singleInvalidator.valueForPFER, doPFER);
                    this.singleInvalidator = null;
                }
            } else {
                Invalidator invalidator = this.invalidators.remove(owner);
                if (invalidator != null) {
                    this.pferValueIfNeeded(owner, key, invalidator.valueForPFER, doPFER);
                }
            }
            this.lastInvalidationEnd = Math.max(this.lastInvalidationEnd, now);
        }

        private void pferValueIfNeeded(Object owner, Object key, Object valueForPFER, boolean doPFER) {
            if (trace) {
                log.tracef("Put for external read value, if needed (doPFER=%b): key=%s, valueForPFER=%s, owner=%s", new Object[]{doPFER, key, valueForPFER, owner});
            }
            if (valueForPFER != null) {
                PendingPut pendingPut = this.remove(owner);
                if (doPFER && pendingPut != null && !pendingPut.completed) {
                    PutFromLoadValidator.this.cache.putIfAbsent(key, valueForPFER);
                }
            }
        }

        public boolean canRemove() {
            return this.size() == 0 && !this.hasInvalidator() && this.lastInvalidationEnd == Long.MIN_VALUE;
        }

        public void setRemoved() {
            this.removed = true;
        }

        public boolean isRemoved() {
            return this.removed;
        }
    }

    private static class PendingPut {
        final Object owner;
        boolean completed;
        private long registeredTimestamp = Long.MIN_VALUE;

        PendingPut(Object owner) {
            this.owner = owner;
        }

        public String toString() {
            return (this.completed ? "C@" : "R@") + PutFromLoadValidator.lockOwnerToString(this.owner);
        }

        public boolean invalidate(long now, long expirationPeriod) {
            this.completed = true;
            return this.gc(now, expirationPeriod);
        }

        public boolean gc(long now, long expirationPeriod) {
            if (this.registeredTimestamp == Long.MIN_VALUE) {
                this.registeredTimestamp = now;
            } else if (this.registeredTimestamp + expirationPeriod < now) {
                return true;
            }
            return false;
        }
    }

    private static class Invalidator {
        final Object owner;
        final long registeredTimestamp;
        final Object valueForPFER;

        Invalidator(Object owner, long registeredTimestamp, Object valueForPFER) {
            this.owner = owner;
            this.registeredTimestamp = registeredTimestamp;
            this.valueForPFER = valueForPFER;
        }

        public String toString() {
            return "{Owner=" + PutFromLoadValidator.lockOwnerToString(this.owner) + ", Timestamp=" + this.registeredTimestamp + '}';
        }
    }

    static class Lock {
        private Lock() {
        }
    }
}

