/*
 * Decompiled with CFR 0.152.
 */
package io.github.dmlloyd.classfile.instruction;

import io.github.dmlloyd.classfile.Instruction;
import io.github.dmlloyd.classfile.Opcode;
import io.github.dmlloyd.classfile.constantpool.ClassEntry;
import io.github.dmlloyd.classfile.constantpool.FieldRefEntry;
import io.github.dmlloyd.classfile.constantpool.NameAndTypeEntry;
import io.github.dmlloyd.classfile.constantpool.Utf8Entry;
import io.github.dmlloyd.classfile.impl.AbstractInstruction;
import io.github.dmlloyd.classfile.impl.TemporaryConstantPool;
import io.github.dmlloyd.classfile.impl.Util;
import java.lang.constant.ClassDesc;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface FieldInstruction
extends Instruction {
    public FieldRefEntry field();

    default public ClassEntry owner() {
        return this.field().owner();
    }

    default public Utf8Entry name() {
        return this.field().nameAndType().name();
    }

    default public Utf8Entry type() {
        return this.field().nameAndType().type();
    }

    default public ClassDesc typeSymbol() {
        return this.field().typeSymbol();
    }

    public static FieldInstruction of(Opcode op, FieldRefEntry field) {
        Util.checkKind(op, Opcode.Kind.FIELD_ACCESS);
        return new AbstractInstruction.UnboundFieldInstruction(op, field);
    }

    public static FieldInstruction of(Opcode op, ClassEntry owner, Utf8Entry name, Utf8Entry type) {
        return FieldInstruction.of(op, owner, TemporaryConstantPool.INSTANCE.nameAndTypeEntry(name, type));
    }

    public static FieldInstruction of(Opcode op, ClassEntry owner, NameAndTypeEntry nameAndType) {
        return FieldInstruction.of(op, TemporaryConstantPool.INSTANCE.fieldRefEntry(owner, nameAndType));
    }
}

