/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.shutdown;

import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.smallrye.config.ConfigMapping;
import java.time.Duration;
import java.util.Optional;

@ConfigMapping(prefix="quarkus.shutdown")
@ConfigRoot(phase=ConfigPhase.RUN_TIME)
public interface ShutdownConfig {
    public Optional<Duration> timeout();

    public Optional<Duration> delay();

    default public boolean isTimeoutEnabled() {
        return this.timeout().isPresent() && this.timeout().get().toMillis() > 0L && LaunchMode.current() != LaunchMode.DEVELOPMENT;
    }

    default public boolean isDelayEnabled() {
        return this.delay().isPresent() && this.delay().get().toMillis() > 0L && LaunchMode.current() != LaunchMode.DEVELOPMENT;
    }
}

