/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.oid4vci;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.oid4vci.Oid4vcProtocolMapperModel;

public class CredentialScopeModel
implements ClientScopeModel {
    public static final String SD_JWT_VISIBLE_CLAIMS_DEFAULT = "id,iat,nbf,exp,jti";
    public static final int SD_JWT_DECOYS_DEFAULT = 10;
    public static final String FORMAT_DEFAULT = "dc+sd-jwt";
    public static final String HASH_ALGORITHM_DEFAULT = "SHA-256";
    public static final String TOKEN_TYPE_DEFAULT = "JWS";
    public static final int EXPIRY_IN_SECONDS_DEFAULT = 31536000;
    public static final String CRYPTOGRAPHIC_BINDING_METHODS_DEFAULT = "jwk";
    public static final String ISSUER_DID = "vc.issuer_did";
    public static final String CONFIGURATION_ID = "vc.credential_configuration_id";
    public static final String CREDENTIAL_IDENTIFIER = "vc.credential_identifier";
    public static final String FORMAT = "vc.format";
    public static final String EXPIRY_IN_SECONDS = "vc.expiry_in_seconds";
    public static final String VCT = "vc.verifiable_credential_type";
    public static final String TYPES = "vc.supported_credential_types";
    public static final String CONTEXTS = "vc.credential_contexts";
    public static final String SIGNING_ALG_VALUES_SUPPORTED = "vc.proof_signing_alg_values_supported";
    public static final String CRYPTOGRAPHIC_BINDING_METHODS = "vc.cryptographic_binding_methods_supported";
    public static final String SIGNING_KEY_ID = "vc.signing_key_id";
    public static final String VC_DISPLAY = "vc.display";
    public static final String SD_JWT_NUMBER_OF_DECOYS = "vc.sd_jwt.number_of_decoys";
    public static final String SD_JWT_VISIBLE_CLAIMS = "vc.credential_build_config.sd_jwt.visible_claims";
    public static final String HASH_ALGORITHM = "vc.credential_build_config.hash_algorithm";
    public static final String TOKEN_JWS_TYPE = "vc.credential_build_config.token_jws_type";
    public static final String INCLUDE_IN_METADATA = "vc.include_in_metadata";
    private final ClientScopeModel clientScope;

    public CredentialScopeModel(ClientScopeModel clientScope) {
        this.clientScope = clientScope;
        assert ("oid4vc".equals(clientScope.getProtocol()));
    }

    public String getIssuerDid() {
        return this.clientScope.getAttribute(ISSUER_DID);
    }

    public void setIssuerDid(String issuerDid) {
        this.clientScope.setAttribute(ISSUER_DID, issuerDid);
    }

    public String getScope() {
        return this.clientScope.getName();
    }

    public String getCredentialConfigurationId() {
        return Optional.ofNullable(this.clientScope.getAttribute(CONFIGURATION_ID)).orElse(this.getName());
    }

    public void setCredentialConfigurationId(String credentialConfigurationId) {
        this.clientScope.setAttribute(CONFIGURATION_ID, Optional.ofNullable(credentialConfigurationId).orElse(this.getName()));
    }

    public String getCredentialIdentifier() {
        return Optional.ofNullable(this.clientScope.getAttribute(CREDENTIAL_IDENTIFIER)).orElse(this.getName());
    }

    public void setCredentialIdentifier(String credentialIdentifier) {
        this.clientScope.setAttribute(CREDENTIAL_IDENTIFIER, Optional.ofNullable(credentialIdentifier).orElse(this.getName()));
    }

    public String getFormat() {
        return Optional.ofNullable(this.clientScope.getAttribute(FORMAT)).orElse(FORMAT_DEFAULT);
    }

    public void setFormat(String credentialFormat) {
        this.clientScope.setAttribute(FORMAT, Optional.ofNullable(credentialFormat).orElse(FORMAT_DEFAULT));
    }

    public Integer getExpiryInSeconds() {
        return Optional.ofNullable(this.clientScope.getAttribute(EXPIRY_IN_SECONDS)).map(Integer::parseInt).orElse(31536000);
    }

    public void setExpiryInSeconds(Integer expiryInSeconds) {
        this.clientScope.setAttribute(EXPIRY_IN_SECONDS, Optional.ofNullable(expiryInSeconds).map(String::valueOf).orElse(String.valueOf(31536000)));
    }

    public int getSdJwtNumberOfDecoys() {
        return Optional.ofNullable(this.clientScope.getAttribute(SD_JWT_NUMBER_OF_DECOYS)).map(Integer::parseInt).orElse(10);
    }

    public void setSdJwtNumberOfDecoys(Integer sdJwtNumberOfDecoys) {
        this.clientScope.setAttribute(SD_JWT_NUMBER_OF_DECOYS, Optional.ofNullable(sdJwtNumberOfDecoys).map(String::valueOf).orElse(String.valueOf(10)));
    }

    public String getVct() {
        return Optional.ofNullable(this.clientScope.getAttribute(VCT)).orElse(this.getName());
    }

    public void setVct(String vct) {
        this.clientScope.setAttribute(VCT, Optional.ofNullable(vct).orElse(this.getName()));
    }

    public String getTokenJwsType() {
        return Optional.ofNullable(this.clientScope.getAttribute(TOKEN_JWS_TYPE)).orElse(TOKEN_TYPE_DEFAULT);
    }

    public void setTokenJwsType(String tokenJwsType) {
        this.clientScope.setAttribute(TOKEN_JWS_TYPE, Optional.ofNullable(tokenJwsType).orElse(TOKEN_TYPE_DEFAULT));
    }

    public String getSigningKeyId() {
        return this.clientScope.getAttribute(SIGNING_KEY_ID);
    }

    public void setSigningKeyId(String signingKeyId) {
        this.clientScope.setAttribute(SIGNING_KEY_ID, signingKeyId);
    }

    public String getHashAlgorithm() {
        return Optional.ofNullable(this.clientScope.getAttribute(HASH_ALGORITHM)).orElse(HASH_ALGORITHM_DEFAULT);
    }

    public void setHashAlgorithm(String hashAlgorithm) {
        this.clientScope.setAttribute(HASH_ALGORITHM, hashAlgorithm);
    }

    public List<String> getSupportedCredentialTypes() {
        return Optional.ofNullable(this.clientScope.getAttribute(TYPES)).map(s -> s.split(",")).map(Arrays::asList).orElse(Collections.singletonList(this.getName()));
    }

    public void setSupportedCredentialTypes(String supportedCredentialTypes) {
        this.clientScope.setAttribute(TYPES, Optional.ofNullable(supportedCredentialTypes).orElse(this.getName()));
    }

    public void setSupportedCredentialTypes(List<String> supportedCredentialTypes) {
        this.clientScope.setAttribute(TYPES, String.join((CharSequence)",", supportedCredentialTypes));
    }

    public List<String> getVcContexts() {
        return Optional.ofNullable(this.clientScope.getAttribute(CONTEXTS)).map(s -> s.split(",")).map(Arrays::asList).orElse(Collections.singletonList(this.getName()));
    }

    public void setVcContexts(String vcContexts) {
        this.clientScope.setAttribute(CONTEXTS, Optional.ofNullable(vcContexts).orElse(this.getName()));
    }

    public void setVcContexts(List<String> vcContexts) {
        this.clientScope.setAttribute(CONTEXTS, String.join((CharSequence)",", vcContexts));
    }

    public List<String> getSigningAlgsSupported() {
        return Optional.ofNullable(this.clientScope.getAttribute(SIGNING_ALG_VALUES_SUPPORTED)).map(s -> s.split(",")).map(Arrays::asList).orElse(Collections.emptyList());
    }

    public void setSigningAlgsSupported(String signingAlgsSupported) {
        this.clientScope.setAttribute(SIGNING_ALG_VALUES_SUPPORTED, signingAlgsSupported);
    }

    public void setSigningAlgsSupported(List<String> signingAlgsSupported) {
        this.clientScope.setAttribute(SIGNING_ALG_VALUES_SUPPORTED, String.join((CharSequence)",", signingAlgsSupported));
    }

    public List<String> getCryptographicBindingMethods() {
        return Optional.ofNullable(this.clientScope.getAttribute(CRYPTOGRAPHIC_BINDING_METHODS)).map(s -> s.split(",")).map(Arrays::asList).orElse(Collections.emptyList());
    }

    public void setCryptographicBindingMethods(String cryptographicBindingMethods) {
        this.clientScope.setAttribute(CRYPTOGRAPHIC_BINDING_METHODS, cryptographicBindingMethods);
    }

    public void setCryptographicBindingMethods(List<String> cryptographicBindingMethods) {
        this.clientScope.setAttribute(CRYPTOGRAPHIC_BINDING_METHODS, String.join((CharSequence)",", cryptographicBindingMethods));
    }

    public List<String> getSdJwtVisibleClaims() {
        return Optional.ofNullable(this.clientScope.getAttribute(SD_JWT_VISIBLE_CLAIMS)).map(s -> s.split(",")).map(Arrays::asList).orElse(List.of(SD_JWT_VISIBLE_CLAIMS_DEFAULT.split(",")));
    }

    public void setSdJwtVisibleClaims(String sdJwtVisibleClaims) {
        this.clientScope.setAttribute(SD_JWT_VISIBLE_CLAIMS, Optional.ofNullable(sdJwtVisibleClaims).orElse(SD_JWT_VISIBLE_CLAIMS_DEFAULT));
    }

    public void setSdJwtVisibleClaims(List<String> sdJwtVisibleClaims) {
        this.clientScope.setAttribute(SD_JWT_VISIBLE_CLAIMS, String.join((CharSequence)",", sdJwtVisibleClaims));
    }

    public String getVcDisplay() {
        return this.clientScope.getAttribute(VC_DISPLAY);
    }

    public void setVcDisplay(String vcDisplay) {
        this.clientScope.setAttribute(VC_DISPLAY, vcDisplay);
    }

    public String getId() {
        return this.clientScope.getId();
    }

    public String getName() {
        return this.clientScope.getName();
    }

    public void setName(String name) {
        this.clientScope.setName(name);
    }

    public RealmModel getRealm() {
        return this.clientScope.getRealm();
    }

    public String getDescription() {
        return this.clientScope.getDescription();
    }

    public void setDescription(String description) {
        this.clientScope.setDescription(description);
    }

    public String getProtocol() {
        return this.clientScope.getProtocol();
    }

    public void setProtocol(String protocol) {
        this.clientScope.setProtocol(protocol);
    }

    public void setAttribute(String name, String value) {
        this.clientScope.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        this.clientScope.removeAttribute(name);
    }

    public String getAttribute(String name) {
        return this.clientScope.getAttribute(name);
    }

    public Map<String, String> getAttributes() {
        return this.clientScope.getAttributes();
    }

    public boolean isDisplayOnConsentScreen() {
        return this.clientScope.isDisplayOnConsentScreen();
    }

    public void setDisplayOnConsentScreen(boolean displayOnConsentScreen) {
        this.clientScope.setDisplayOnConsentScreen(displayOnConsentScreen);
    }

    public String getConsentScreenText() {
        return this.clientScope.getConsentScreenText();
    }

    public void setConsentScreenText(String consentScreenText) {
        this.clientScope.setConsentScreenText(consentScreenText);
    }

    public String getGuiOrder() {
        return this.clientScope.getGuiOrder();
    }

    public void setGuiOrder(String guiOrder) {
        this.clientScope.setGuiOrder(guiOrder);
    }

    public boolean isIncludeInTokenScope() {
        return this.clientScope.isIncludeInTokenScope();
    }

    public void setIncludeInTokenScope(boolean includeInTokenScope) {
        this.clientScope.setIncludeInTokenScope(includeInTokenScope);
    }

    public boolean isDynamicScope() {
        return this.clientScope.isDynamicScope();
    }

    public void setIsDynamicScope(boolean isDynamicScope) {
        this.clientScope.setIsDynamicScope(isDynamicScope);
    }

    public String getDynamicScopeRegexp() {
        return this.clientScope.getDynamicScopeRegexp();
    }

    public Stream<Oid4vcProtocolMapperModel> getOid4vcProtocolMappersStream() {
        return this.clientScope.getProtocolMappersStream().filter(pm -> "oid4vc".equals(pm.getProtocol())).map(Oid4vcProtocolMapperModel::new);
    }

    public Stream<ProtocolMapperModel> getProtocolMappersStream() {
        return this.clientScope.getProtocolMappersStream();
    }

    public ProtocolMapperModel addProtocolMapper(ProtocolMapperModel model) {
        return this.clientScope.addProtocolMapper(model);
    }

    public void removeProtocolMapper(ProtocolMapperModel mapping) {
        this.clientScope.removeProtocolMapper(mapping);
    }

    public void updateProtocolMapper(ProtocolMapperModel mapping) {
        this.clientScope.updateProtocolMapper(mapping);
    }

    public ProtocolMapperModel getProtocolMapperById(String id) {
        return this.clientScope.getProtocolMapperById(id);
    }

    public List<ProtocolMapperModel> getProtocolMapperByType(String type) {
        return this.clientScope.getProtocolMapperByType(type);
    }

    public ProtocolMapperModel getProtocolMapperByName(String protocol, String name) {
        return this.clientScope.getProtocolMapperByName(protocol, name);
    }

    public Stream<RoleModel> getScopeMappingsStream() {
        return this.clientScope.getScopeMappingsStream();
    }

    public Stream<RoleModel> getRealmScopeMappingsStream() {
        return this.clientScope.getRealmScopeMappingsStream();
    }

    public void addScopeMapping(RoleModel role) {
        this.clientScope.addScopeMapping(role);
    }

    public void deleteScopeMapping(RoleModel role) {
        this.clientScope.deleteScopeMapping(role);
    }

    public boolean hasDirectScope(RoleModel role) {
        return this.clientScope.hasDirectScope(role);
    }

    public boolean hasScope(RoleModel role) {
        return this.clientScope.hasScope(role);
    }
}

