/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.deployment.webjar;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsProduction;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.maven.dependency.GACT;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.runtime.ApplicationConfig;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.vertx.http.deployment.webjar.WebJarBuildItem;
import io.quarkus.vertx.http.deployment.webjar.WebJarResultsBuildItem;
import io.quarkus.vertx.http.deployment.webjar.WebJarUtil;
import io.quarkus.vertx.http.runtime.devmode.FileSystemStaticHandler;
import io.quarkus.vertx.http.runtime.webjar.WebJarRecorder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WebJarProcessor {
    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep(onlyIfNot={IsProduction.class})
    WebJarResultsBuildItem processWebJarDevMode(WebJarRecorder recorder, List<WebJarBuildItem> webJars, CurateOutcomeBuildItem curateOutcomeBuildItem, ShutdownContextBuildItem shutdownContext, ApplicationConfig applicationConfig) throws IOException {
        HashMap<GACT, WebJarResultsBuildItem.WebJarResult> results = new HashMap<GACT, WebJarResultsBuildItem.WebJarResult>();
        Path deploymentBasePath = Files.createTempDirectory("quarkus-webjar", new FileAttribute[0]);
        recorder.shutdownTask((ShutdownContext)shutdownContext, deploymentBasePath.toString());
        for (WebJarBuildItem webJar : webJars) {
            Path resourcesDirectory = deploymentBasePath.resolve(this.buildFinalDestination(webJar.getArtifactKey(), webJar.getRoot()));
            ResolvedDependency dependency = WebJarUtil.getAppArtifact(curateOutcomeBuildItem, webJar.getArtifactKey());
            Path staticResourcesPath = WebJarUtil.copyResourcesForDevOrTest(curateOutcomeBuildItem, applicationConfig, webJar, dependency, resourcesDirectory);
            ArrayList<FileSystemStaticHandler.StaticWebRootConfiguration> webRootConfigurations = new ArrayList<FileSystemStaticHandler.StaticWebRootConfiguration>();
            webRootConfigurations.add(new FileSystemStaticHandler.StaticWebRootConfiguration(staticResourcesPath.toAbsolutePath().toString(), ""));
            for (Path resolvedPath : dependency.getResolvedPaths()) {
                webRootConfigurations.add(new FileSystemStaticHandler.StaticWebRootConfiguration(resolvedPath.toString(), webJar.getRoot()));
            }
            results.put(webJar.getArtifactKey(), new WebJarResultsBuildItem.WebJarResult(dependency, staticResourcesPath.toAbsolutePath().toString(), webRootConfigurations));
        }
        return new WebJarResultsBuildItem(results);
    }

    @BuildStep(onlyIf={IsProduction.class})
    WebJarResultsBuildItem processWebJarProdMode(List<WebJarBuildItem> webJars, CurateOutcomeBuildItem curateOutcomeBuildItem, BuildProducer<GeneratedResourceBuildItem> generatedResources, BuildProducer<NativeImageResourceBuildItem> nativeImageResourceBuildItemBuildProducer, ApplicationConfig applicationConfig) {
        HashMap<GACT, WebJarResultsBuildItem.WebJarResult> results = new HashMap<GACT, WebJarResultsBuildItem.WebJarResult>();
        for (WebJarBuildItem webJar : webJars) {
            ResolvedDependency dependency = WebJarUtil.getAppArtifact(curateOutcomeBuildItem, webJar.getArtifactKey());
            Map<String, byte[]> files = WebJarUtil.copyResourcesForProduction(curateOutcomeBuildItem, applicationConfig, webJar, dependency);
            String finalDestination = this.buildFinalDestination(webJar.getArtifactKey(), webJar.getRoot());
            for (Map.Entry<String, byte[]> file : files.entrySet()) {
                String fileName = finalDestination + "/" + file.getKey();
                byte[] fileContent = file.getValue();
                generatedResources.produce((BuildItem)new GeneratedResourceBuildItem(fileName, fileContent));
                nativeImageResourceBuildItemBuildProducer.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{fileName}));
            }
            ArrayList<FileSystemStaticHandler.StaticWebRootConfiguration> webRootConfigurations = new ArrayList<FileSystemStaticHandler.StaticWebRootConfiguration>();
            webRootConfigurations.add(new FileSystemStaticHandler.StaticWebRootConfiguration(finalDestination, ""));
            results.put(webJar.getArtifactKey(), new WebJarResultsBuildItem.WebJarResult(dependency, finalDestination, webRootConfigurations));
        }
        return new WebJarResultsBuildItem(results);
    }

    private String buildFinalDestination(GACT artifactKey, String webRoot) {
        Object finalDestination = "META-INF/" + artifactKey.toString().replace(":", "_") + "/" + webRoot;
        if (((String)finalDestination).endsWith("/")) {
            finalDestination = ((String)finalDestination).substring(0, ((String)finalDestination).length() - 1);
        }
        return finalDestination;
    }
}

