/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.runtimemetrics.java17.internal.classes;

import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.instrumentation.runtimemetrics.java17.JfrFeature;
import io.opentelemetry.instrumentation.runtimemetrics.java17.internal.RecordedEventHandler;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import jdk.jfr.consumer.RecordedEvent;

public final class ClassesLoadedHandler
implements RecordedEventHandler {
    private static final String METRIC_NAME_LOADED = "jvm.class.loaded";
    private static final String METRIC_NAME_UNLOADED = "jvm.class.unloaded";
    private static final String METRIC_NAME_CURRENT = "jvm.class.count";
    private static final String EVENT_NAME = "jdk.ClassLoadingStatistics";
    private static final String METRIC_DESCRIPTION_CURRENT = "Number of classes currently loaded.";
    private static final String METRIC_DESCRIPTION_LOADED = "Number of classes loaded since JVM start.";
    private static final String METRIC_DESCRIPTION_UNLOADED = "Number of classes unloaded since JVM start.";
    private final List<AutoCloseable> observables = new ArrayList<AutoCloseable>();
    private volatile long loaded = 0L;
    private volatile long unloaded = 0L;

    public ClassesLoadedHandler(Meter meter) {
        this.observables.add((AutoCloseable)meter.upDownCounterBuilder(METRIC_NAME_CURRENT).setDescription(METRIC_DESCRIPTION_CURRENT).setUnit("{class}").buildWithCallback(measurement -> measurement.record(this.loaded - this.unloaded)));
        this.observables.add((AutoCloseable)meter.counterBuilder(METRIC_NAME_LOADED).setDescription(METRIC_DESCRIPTION_LOADED).setUnit("{class}").buildWithCallback(measurement -> measurement.record(this.loaded)));
        this.observables.add((AutoCloseable)meter.counterBuilder(METRIC_NAME_UNLOADED).setDescription(METRIC_DESCRIPTION_UNLOADED).setUnit("{class}").buildWithCallback(measurement -> measurement.record(this.unloaded)));
    }

    @Override
    public void accept(RecordedEvent ev) {
        this.loaded = ev.getLong("loadedClassCount");
        this.unloaded = ev.getLong("unloadedClassCount");
    }

    @Override
    public String getEventName() {
        return EVENT_NAME;
    }

    @Override
    public JfrFeature getFeature() {
        return JfrFeature.CLASS_LOAD_METRICS;
    }

    @Override
    public Optional<Duration> getPollingDuration() {
        return Optional.of(Duration.ofSeconds(1L));
    }

    @Override
    public void close() {
        RecordedEventHandler.closeObservables(this.observables);
    }
}

