/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.exportimport.singlefile;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.keycloak.Config;
import org.keycloak.exportimport.ExportImportConfig;
import org.keycloak.exportimport.ImportProvider;
import org.keycloak.exportimport.ImportProviderFactory;
import org.keycloak.exportimport.Strategy;
import org.keycloak.exportimport.singlefile.SingleFileImportProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;

public class SingleFileImportProviderFactory
implements ImportProviderFactory {
    public static final String PROVIDER_ID = "singleFile";
    public static final String REALM_NAME = "realmName";
    public static final String STRATEGY = "strategy";
    public static final String FILE = "file";
    private Config.Scope config;

    public ImportProvider create(KeycloakSession session, Map<String, String> overrides) {
        Strategy strategy = Enum.valueOf(Strategy.class, System.getProperty("keycloak.migration.strategy", this.config.get(STRATEGY, ExportImportConfig.DEFAULT_STRATEGY.toString())));
        String fileName = overrides.getOrDefault("keycloak.migration.file", System.getProperty("keycloak.migration.file", this.config.get(FILE)));
        if (fileName == null) {
            throw new IllegalArgumentException("Property file needs to be provided!");
        }
        return new SingleFileImportProvider(session.getKeycloakSessionFactory(), new File(fileName), strategy);
    }

    public void init(Config.Scope config) {
        this.config = config;
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public List<ProviderConfigProperty> getConfigMetadata() {
        return ProviderConfigurationBuilder.create().property().name(REALM_NAME).type("string").helpText("Realm to export").add().property().name(FILE).type("string").helpText("File to import from").add().property().name(STRATEGY).type("string").helpText("Strategy for import: " + Strategy.IGNORE_EXISTING.name() + ", " + String.valueOf(Strategy.OVERWRITE_EXISTING)).add().build();
    }
}

