/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jandex;

import java.util.List;
import java.util.function.Function;
import org.jboss.jandex.ArrayType;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.RecordComponentInfo;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeVariable;
import org.jboss.jandex.WildcardType;

final class GenericSignatureReconstruction {
    GenericSignatureReconstruction() {
    }

    static boolean requiresGenericSignature(ClassInfo clazz) {
        if (!clazz.typeParameters().isEmpty()) {
            return true;
        }
        Type superType = clazz.superClassType();
        if (superType.kind() == Type.Kind.PARAMETERIZED_TYPE) {
            return true;
        }
        for (Type superType2 : clazz.interfaceTypes()) {
            if (superType2.kind() != Type.Kind.PARAMETERIZED_TYPE) continue;
            return true;
        }
        return false;
    }

    static boolean requiresGenericSignature(MethodInfo method) {
        if (!method.typeParameters().isEmpty()) {
            return true;
        }
        if (GenericSignatureReconstruction.requiresGenericSignature(method.returnType())) {
            return true;
        }
        for (Type parameterType : method.parameterTypes()) {
            if (!GenericSignatureReconstruction.requiresGenericSignature(parameterType)) continue;
            return true;
        }
        return GenericSignatureReconstruction.hasThrowsSignature(method);
    }

    static boolean requiresGenericSignature(FieldInfo field) {
        return GenericSignatureReconstruction.requiresGenericSignature(field.type());
    }

    static boolean requiresGenericSignature(RecordComponentInfo recordComponent) {
        return GenericSignatureReconstruction.requiresGenericSignature(recordComponent.type());
    }

    private static boolean requiresGenericSignature(Type type) {
        return type.kind() == Type.Kind.TYPE_VARIABLE || type.kind() == Type.Kind.UNRESOLVED_TYPE_VARIABLE || type.kind() == Type.Kind.PARAMETERIZED_TYPE;
    }

    static String reconstructGenericSignature(ClassInfo clazz, Function<String, Type> typeVariableSubstitution) {
        StringBuilder result = new StringBuilder();
        if (!clazz.typeParameters().isEmpty()) {
            GenericSignatureReconstruction.typeParametersSignature(clazz.typeParameters(), typeVariableSubstitution, result);
        }
        GenericSignatureReconstruction.typeSignature(clazz.superClassType(), typeVariableSubstitution, result);
        for (Type interfaceType : clazz.interfaceTypes()) {
            GenericSignatureReconstruction.typeSignature(interfaceType, typeVariableSubstitution, result);
        }
        return result.toString();
    }

    static String reconstructGenericSignature(MethodInfo method, Function<String, Type> typeVariableSubstitution) {
        StringBuilder result = new StringBuilder();
        if (!method.typeParameters().isEmpty()) {
            GenericSignatureReconstruction.typeParametersSignature(method.typeParameters(), typeVariableSubstitution, result);
        }
        result.append('(');
        for (Type parameter : method.parameterTypes()) {
            GenericSignatureReconstruction.typeSignature(parameter, typeVariableSubstitution, result);
        }
        result.append(')');
        GenericSignatureReconstruction.typeSignature(method.returnType(), typeVariableSubstitution, result);
        if (GenericSignatureReconstruction.hasThrowsSignature(method)) {
            for (Type exception : method.exceptions()) {
                result.append('^');
                GenericSignatureReconstruction.typeSignature(exception, typeVariableSubstitution, result);
            }
        }
        return result.toString();
    }

    static String reconstructGenericSignature(FieldInfo field, Function<String, Type> typeVariableSubstitution) {
        StringBuilder result = new StringBuilder();
        GenericSignatureReconstruction.typeSignature(field.type(), typeVariableSubstitution, result);
        return result.toString();
    }

    static String reconstructGenericSignature(RecordComponentInfo recordComponent, Function<String, Type> typeVariableSubstitution) {
        StringBuilder result = new StringBuilder();
        GenericSignatureReconstruction.typeSignature(recordComponent.type(), typeVariableSubstitution, result);
        return result.toString();
    }

    private static boolean hasThrowsSignature(MethodInfo method) {
        for (Type type : method.exceptions()) {
            if (type.kind() != Type.Kind.TYPE_VARIABLE && type.kind() != Type.Kind.UNRESOLVED_TYPE_VARIABLE) continue;
            return true;
        }
        return false;
    }

    static void typeParametersSignature(List<TypeVariable> typeParameters, Function<String, Type> substitution, StringBuilder result) {
        if (typeParameters.isEmpty()) {
            return;
        }
        result.append('<');
        for (TypeVariable typeParameter : typeParameters) {
            result.append(typeParameter.identifier());
            if (typeParameter.hasImplicitObjectBound()) {
                result.append(':');
            }
            for (Type bound : typeParameter.bounds()) {
                result.append(':');
                GenericSignatureReconstruction.typeSignature(bound, substitution, result);
            }
        }
        result.append('>');
    }

    static void typeSignature(Type type, Function<String, Type> substitution, StringBuilder result) {
        switch (type.kind()) {
            case VOID: {
                result.append('V');
                break;
            }
            case PRIMITIVE: {
                PrimitiveType.Primitive primitive = type.asPrimitiveType().primitive();
                switch (primitive) {
                    case BOOLEAN: {
                        result.append('Z');
                        return;
                    }
                    case CHAR: {
                        result.append('C');
                        return;
                    }
                    case BYTE: {
                        result.append('B');
                        return;
                    }
                    case SHORT: {
                        result.append('S');
                        return;
                    }
                    case INT: {
                        result.append('I');
                        return;
                    }
                    case LONG: {
                        result.append('J');
                        return;
                    }
                    case FLOAT: {
                        result.append('F');
                        return;
                    }
                    case DOUBLE: {
                        result.append('D');
                        return;
                    }
                }
                throw new IllegalArgumentException("unkown primitive type " + (Object)((Object)primitive));
            }
            case CLASS: {
                ClassType classType = type.asClassType();
                result.append('L').append(classType.name().toString('/')).append(';');
                break;
            }
            case ARRAY: {
                ArrayType arrayType = type.asArrayType();
                for (int i = 0; i < arrayType.dimensions(); ++i) {
                    result.append('[');
                }
                GenericSignatureReconstruction.typeSignature(arrayType.component(), substitution, result);
                break;
            }
            case PARAMETERIZED_TYPE: {
                ParameterizedType parameterizedType = type.asParameterizedType();
                Type owner = parameterizedType.owner();
                if (owner != null && owner.kind() == Type.Kind.PARAMETERIZED_TYPE) {
                    GenericSignatureReconstruction.typeSignature(owner, substitution, result);
                    assert (result.charAt(result.length() - 1) == ';');
                    result.setCharAt(result.length() - 1, '.');
                    result.append(parameterizedType.name().local());
                } else {
                    result.append('L').append(parameterizedType.name().toString('/'));
                }
                if (!parameterizedType.arguments().isEmpty()) {
                    result.append('<');
                    for (Type argument : parameterizedType.arguments()) {
                        GenericSignatureReconstruction.typeSignature(argument, substitution, result);
                    }
                    result.append('>');
                }
                result.append(';');
                break;
            }
            case TYPE_VARIABLE: {
                GenericSignatureReconstruction.typeVariableSignature(type, type.asTypeVariable().identifier(), substitution, result);
                break;
            }
            case UNRESOLVED_TYPE_VARIABLE: {
                GenericSignatureReconstruction.typeVariableSignature(type, type.asUnresolvedTypeVariable().identifier(), substitution, result);
                break;
            }
            case TYPE_VARIABLE_REFERENCE: {
                GenericSignatureReconstruction.typeVariableSignature(type, type.asTypeVariableReference().identifier(), substitution, result);
                break;
            }
            case WILDCARD_TYPE: {
                WildcardType wildcardType = type.asWildcardType();
                if (wildcardType.superBound() != null) {
                    result.append('-');
                    GenericSignatureReconstruction.typeSignature(wildcardType.superBound(), substitution, result);
                    break;
                }
                if (ClassType.OBJECT_TYPE.equals(wildcardType.extendsBound())) {
                    result.append('*');
                    break;
                }
                result.append('+');
                GenericSignatureReconstruction.typeSignature(wildcardType.extendsBound(), substitution, result);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown type " + type);
            }
        }
    }

    private static void typeVariableSignature(Type typeVariable, String typeVariableIdentifier, Function<String, Type> substitution, StringBuilder result) {
        Type type;
        Type type2 = type = substitution == null ? null : substitution.apply(typeVariableIdentifier);
        if (type == null || type == typeVariable) {
            result.append('T').append(typeVariableIdentifier).append(';');
        } else {
            GenericSignatureReconstruction.typeSignature(type, substitution, result);
        }
    }
}

