/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.representations.userprofile.config;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.keycloak.representations.userprofile.config.UPAttributePermissions;
import org.keycloak.representations.userprofile.config.UPAttributeRequired;
import org.keycloak.representations.userprofile.config.UPAttributeSelector;
import org.keycloak.representations.userprofile.config.UPGroup;

public class UPAttribute
implements Cloneable {
    private String name;
    private String displayName;
    private Map<String, Map<String, Object>> validations;
    private Map<String, Object> annotations;
    private UPAttributeRequired required;
    private UPAttributePermissions permissions;
    private UPAttributeSelector selector;
    private String group;
    private boolean multivalued;
    private String defaultValue;

    public UPAttribute() {
    }

    public UPAttribute(String name) {
        this.name = name != null ? name.trim() : null;
    }

    public UPAttribute(String name, UPGroup group) {
        this(name);
        this.group = group.getName();
    }

    public UPAttribute(String name, UPAttributePermissions permissions, UPAttributeRequired required, UPAttributeSelector selector) {
        this(name);
        this.permissions = permissions;
        this.required = required;
        this.selector = selector;
    }

    public UPAttribute(String name, UPAttributePermissions permissions, UPAttributeRequired required) {
        this(name, permissions, required, null);
    }

    public UPAttribute(String name, UPAttributePermissions permissions) {
        this(name, permissions, null);
    }

    public UPAttribute(String name, boolean multivalued, UPAttributePermissions permissions) {
        this(name, permissions, null);
        this.setMultivalued(multivalued);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name != null ? name.trim() : null;
    }

    public Map<String, Map<String, Object>> getValidations() {
        return this.validations;
    }

    public void setValidations(Map<String, Map<String, Object>> validations) {
        this.validations = validations;
    }

    public Map<String, Object> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(Map<String, Object> annotations) {
        this.annotations = annotations;
    }

    public UPAttributeRequired getRequired() {
        return this.required;
    }

    public void setRequired(UPAttributeRequired required) {
        this.required = required;
    }

    public UPAttributePermissions getPermissions() {
        return this.permissions;
    }

    public void setPermissions(UPAttributePermissions permissions) {
        this.permissions = permissions;
    }

    public void addValidation(String validator, Map<String, Object> config) {
        if (this.validations == null) {
            this.validations = new HashMap<String, Map<String, Object>>();
        }
        this.validations.put(validator, config);
    }

    public UPAttributeSelector getSelector() {
        return this.selector;
    }

    public void setSelector(UPAttributeSelector selector) {
        this.selector = selector;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group != null ? group.trim() : null;
    }

    public void setMultivalued(boolean multivalued) {
        this.multivalued = multivalued;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean isMultivalued() {
        return this.multivalued;
    }

    public String toString() {
        return "UPAttribute [name=" + this.name + ", displayName=" + this.displayName + ", permissions=" + this.permissions + ", selector=" + this.selector + ", required=" + this.required + ", validations=" + this.validations + ", annotations=" + this.annotations + ", group=" + this.group + ", multivalued=" + this.multivalued + ", defaultValue=" + this.defaultValue + "]";
    }

    protected UPAttribute clone() {
        LinkedHashMap<String, Map<String, Object>> validations;
        UPAttribute attr = new UPAttribute(this.name);
        attr.setDisplayName(this.displayName);
        if (this.validations == null) {
            validations = null;
        } else {
            validations = new LinkedHashMap<String, Map<String, Object>>();
            for (Map.Entry<String, Map<String, Object>> entry : this.validations.entrySet()) {
                LinkedHashMap<String, Object> newVal = entry.getValue() == null ? null : new LinkedHashMap<String, Object>(entry.getValue());
                validations.put(entry.getKey(), newVal);
            }
        }
        attr.setValidations(validations);
        attr.setAnnotations((Map<String, Object>)(this.annotations == null ? null : new HashMap<String, Object>(this.annotations)));
        attr.setRequired(this.required == null ? null : this.required.clone());
        attr.setPermissions(this.permissions == null ? null : this.permissions.clone());
        attr.setSelector(this.selector == null ? null : this.selector.clone());
        attr.setGroup(this.group);
        attr.setMultivalued(this.multivalued);
        attr.setDefaultValue(this.defaultValue);
        return attr;
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        UPAttribute other = (UPAttribute)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.group, other.group) && Objects.equals(this.validations, other.validations) && Objects.equals(this.annotations, other.annotations) && Objects.equals(this.required, other.required) && Objects.equals(this.permissions, other.permissions) && Objects.equals(this.selector, other.selector) && Objects.equals(this.multivalued, other.multivalued) && Objects.equals(this.defaultValue, other.defaultValue);
    }
}

