/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.binder.virtualthreads;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.quarkus.micrometer.runtime.config.MicrometerConfig;
import io.quarkus.micrometer.runtime.config.VirtualThreadsConfigGroup;
import io.quarkus.runtime.ShutdownEvent;
import io.quarkus.runtime.StartupEvent;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

@ApplicationScoped
public class VirtualThreadCollector {
    private static final String VIRTUAL_THREAD_BINDER_CLASSNAME = "io.micrometer.java21.instrument.binder.jdk.VirtualThreadMetrics";
    private static final Logger LOGGER = Logger.getLogger(VirtualThreadCollector.class);
    final MeterRegistry registry = Metrics.globalRegistry;
    private final boolean enabled;
    private final MeterBinder binder;
    private final List<Tag> tags;

    @Inject
    public VirtualThreadCollector(MicrometerConfig mc) {
        VirtualThreadsConfigGroup config = mc.binder().virtualThreads();
        this.enabled = Runtime.version().major() >= 21 && config.enabled().orElse(true) != false;
        MeterBinder instantiated = null;
        if (this.enabled) {
            if (config.tags().isPresent()) {
                List<String> list = config.tags().get();
                this.tags = list.stream().map(this::createTagFromEntry).collect(Collectors.toList());
            } else {
                this.tags = List.of();
            }
            try {
                instantiated = this.instantiate(this.tags);
            }
            catch (Exception e) {
                LOGGER.warnf((Throwable)e, "Failed to instantiate io.micrometer.java21.instrument.binder.jdk.VirtualThreadMetrics", new Object[0]);
            }
        } else {
            this.tags = List.of();
        }
        this.binder = instantiated;
    }

    public MeterBinder instantiate(List<Tag> tags) {
        try {
            Class<?> clazz = Class.forName(VIRTUAL_THREAD_BINDER_CLASSNAME);
            return (MeterBinder)clazz.getDeclaredConstructor(Iterable.class).newInstance(tags);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to instantiate io.micrometer.java21.instrument.binder.jdk.VirtualThreadMetrics", e);
        }
    }

    private Tag createTagFromEntry(String entry) {
        String[] parts = entry.trim().split("=");
        if (parts.length == 2) {
            return Tag.of((String)parts[0], (String)parts[1]);
        }
        throw new IllegalStateException("Invalid tag: " + entry + " (expected key=value)");
    }

    public MeterBinder getBinder() {
        return this.binder;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void init(@Observes StartupEvent event) {
        if (this.enabled && this.binder != null) {
            this.binder.bindTo(this.registry);
        }
    }

    public void close(@Observes ShutdownEvent event) {
        if (this.binder instanceof Closeable) {
            try {
                ((Closeable)this.binder).close();
            }
            catch (IOException e) {
                LOGGER.warnf((Throwable)e, "Failed to close io.micrometer.java21.instrument.binder.jdk.VirtualThreadMetrics", new Object[0]);
            }
        }
    }
}

