/*
 * Decompiled with CFR 0.152.
 */
package jakarta.el;

import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.ELResolver;
import jakarta.el.ELUtil;
import jakarta.el.PropertyNotFoundException;
import jakarta.el.PropertyNotWritableException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;

public class RecordELResolver
extends ELResolver {
    @Override
    public Object getValue(ELContext context, Object base, Object property) {
        Objects.requireNonNull(context);
        if (base instanceof Record && property != null) {
            Method method;
            context.setPropertyResolved(base, property);
            String propertyName = property.toString();
            try {
                method = base.getClass().getMethod(propertyName, new Class[0]);
            }
            catch (NoSuchMethodException nsme) {
                throw new PropertyNotFoundException(ELUtil.getExceptionMessageString(context, "propertyNotReadable", new Object[]{base.getClass().getName(), property.toString()}));
            }
            try {
                return method.invoke(base, new Object[0]);
            }
            catch (ELException ex) {
                throw ex;
            }
            catch (InvocationTargetException ite) {
                throw new ELException(ite.getCause());
            }
            catch (Exception ex) {
                throw new ELException(ex);
            }
        }
        return null;
    }

    @Override
    public Class<?> getType(ELContext context, Object base, Object property) {
        Objects.requireNonNull(context);
        if (base instanceof Record && property != null) {
            context.setPropertyResolved(base, property);
            String propertyName = property.toString();
            try {
                base.getClass().getMethod(propertyName, new Class[0]);
            }
            catch (NoSuchMethodException nsme) {
                throw new PropertyNotFoundException(ELUtil.getExceptionMessageString(context, "propertyNotReadable", new Object[]{base.getClass().getName(), property.toString()}));
            }
        }
        return null;
    }

    @Override
    public void setValue(ELContext context, Object base, Object property, Object value) {
        Objects.requireNonNull(context);
        if (base instanceof Record && property != null) {
            context.setPropertyResolved(base, property);
            String propertyName = property.toString();
            try {
                base.getClass().getMethod(propertyName, new Class[0]);
            }
            catch (NoSuchMethodException nsme) {
                throw new PropertyNotFoundException(ELUtil.getExceptionMessageString(context, "propertyNotFound", new Object[]{base.getClass().getName(), property.toString()}));
            }
            throw new PropertyNotWritableException(ELUtil.getExceptionMessageString(context, "propertyNotWritable", new Object[]{base.getClass().getName(), property.toString()}));
        }
    }

    @Override
    public boolean isReadOnly(ELContext context, Object base, Object property) {
        Objects.requireNonNull(context);
        if (base instanceof Record && property != null) {
            context.setPropertyResolved(base, property);
            String propertyName = property.toString();
            try {
                base.getClass().getMethod(propertyName, new Class[0]);
            }
            catch (NoSuchMethodException nsme) {
                throw new PropertyNotFoundException(ELUtil.getExceptionMessageString(context, "propertyNotFound", new Object[]{base.getClass().getName(), property.toString()}));
            }
            return true;
        }
        return false;
    }

    @Override
    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (base instanceof Record) {
            return Object.class;
        }
        return null;
    }
}

