/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.spec;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.SessionConfig;
import io.undertow.servlet.UndertowServletMessages;
import io.undertow.servlet.spec.ServletContextImpl;
import jakarta.servlet.SessionCookieConfig;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

public class SessionCookieConfigImpl
implements SessionCookieConfig,
SessionConfig {
    private static final String COOKIE_COMMENT_ATTR = "Comment";
    private static final String COOKIE_DOMAIN_ATTR = "Domain";
    private static final String COOKIE_MAX_AGE_ATTR = "Max-Age";
    private static final String COOKIE_PATH_ATTR = "Path";
    private static final String COOKIE_SECURE_ATTR = "Secure";
    private static final String COOKIE_HTTP_ONLY_ATTR = "HttpOnly";
    private static final String COOKIE_SAME_SITE_ATTR = "SameSite";
    private final ServletContextImpl servletContext;
    private final io.undertow.server.session.SessionCookieConfig delegate;
    private SessionConfig fallback;
    private static final int DEFAULT_MAX_AGE = -1;
    private static final boolean DEFAULT_HTTP_ONLY = false;
    private static final boolean DEFAULT_SECURE = false;
    private static final String DEFAULT_NAME = "JSESSIONID";
    private String name = "JSESSIONID";
    private final Map<String, String> attributes = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);

    public SessionCookieConfigImpl(ServletContextImpl servletContext) {
        this.servletContext = servletContext;
        this.delegate = new io.undertow.server.session.SessionCookieConfig();
    }

    public String rewriteUrl(String originalUrl, String sessionid) {
        if (this.fallback != null) {
            return this.fallback.rewriteUrl(originalUrl, sessionid);
        }
        return originalUrl;
    }

    public void setSessionId(HttpServerExchange exchange, String sessionId) {
        this.delegate.setSessionId(exchange, sessionId);
    }

    public void clearSession(HttpServerExchange exchange, String sessionId) {
        this.delegate.clearSession(exchange, sessionId);
    }

    public String findSessionId(HttpServerExchange exchange) {
        String existing = this.delegate.findSessionId(exchange);
        if (existing != null) {
            return existing;
        }
        if (this.fallback != null) {
            return this.fallback.findSessionId(exchange);
        }
        return null;
    }

    public SessionConfig.SessionCookieSource sessionCookieSource(HttpServerExchange exchange) {
        String existing = this.delegate.findSessionId(exchange);
        if (existing != null) {
            return SessionConfig.SessionCookieSource.COOKIE;
        }
        if (this.fallback != null) {
            String id = this.fallback.findSessionId(exchange);
            return id != null ? this.fallback.sessionCookieSource(exchange) : SessionConfig.SessionCookieSource.NONE;
        }
        return SessionConfig.SessionCookieSource.NONE;
    }

    public String getName() {
        return this.delegate.getCookieName();
    }

    public void setName(String name) {
        if (this.servletContext.isInitialized()) {
            throw UndertowServletMessages.MESSAGES.servletContextAlreadyInitialized();
        }
        this.delegate.setCookieName(name);
    }

    public String getDomain() {
        return this.getAttribute(COOKIE_DOMAIN_ATTR);
    }

    public void setDomain(String domain) {
        if (this.servletContext.isInitialized()) {
            throw UndertowServletMessages.MESSAGES.servletContextAlreadyInitialized();
        }
        this.delegate.setDomain(domain);
        this.setAttribute(COOKIE_DOMAIN_ATTR, domain);
    }

    public String getPath() {
        return this.getAttribute(COOKIE_PATH_ATTR);
    }

    public void setPath(String path) {
        if (this.servletContext.isInitialized()) {
            throw UndertowServletMessages.MESSAGES.servletContextAlreadyInitialized();
        }
        this.delegate.setPath(path);
        this.setAttribute(COOKIE_PATH_ATTR, path);
    }

    @Deprecated
    public String getComment() {
        return this.getAttribute(COOKIE_COMMENT_ATTR);
    }

    @Deprecated
    public void setComment(String comment) {
        if (this.servletContext.isInitialized()) {
            throw UndertowServletMessages.MESSAGES.servletContextAlreadyInitialized();
        }
        this.delegate.setComment(comment);
        this.setAttribute(COOKIE_COMMENT_ATTR, comment);
    }

    public boolean isHttpOnly() {
        String value = this.getAttribute(COOKIE_HTTP_ONLY_ATTR);
        return value == null ? false : Boolean.parseBoolean(value);
    }

    public void setHttpOnly(boolean httpOnly) {
        if (this.servletContext.isInitialized()) {
            throw UndertowServletMessages.MESSAGES.servletContextAlreadyInitialized();
        }
        this.delegate.setHttpOnly(httpOnly);
        this.setAttribute(COOKIE_HTTP_ONLY_ATTR, String.valueOf(httpOnly));
    }

    public boolean isSecure() {
        String value = this.getAttribute(COOKIE_SECURE_ATTR);
        return value == null ? false : Boolean.parseBoolean(value);
    }

    public void setSecure(boolean secure) {
        if (this.servletContext.isInitialized()) {
            throw UndertowServletMessages.MESSAGES.servletContextAlreadyInitialized();
        }
        this.delegate.setSecure(secure);
        this.setAttribute(COOKIE_SECURE_ATTR, String.valueOf(secure));
    }

    public int getMaxAge() {
        String value = this.getAttribute(COOKIE_MAX_AGE_ATTR);
        return value == null ? -1 : Integer.parseInt(value);
    }

    public void setMaxAge(int maxAge) {
        if (this.servletContext.isInitialized()) {
            throw UndertowServletMessages.MESSAGES.servletContextAlreadyInitialized();
        }
        this.delegate.setMaxAge(maxAge);
        this.setAttribute(COOKIE_MAX_AGE_ATTR, String.valueOf(maxAge));
    }

    public SessionConfig getFallback() {
        return this.fallback;
    }

    public void setFallback(SessionConfig fallback) {
        this.fallback = fallback;
    }

    public void setAttribute(String name, String value) {
        if (this.servletContext.isInitialized()) {
            throw UndertowServletMessages.MESSAGES.servletContextAlreadyInitialized();
        }
        this.attributes.put(name, value);
    }

    public String getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Map<String, String> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }
}

