/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal.jdk;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.hibernate.models.IllegalCastException;
import org.hibernate.models.internal.jdk.AbstractJdkAnnotationTarget;
import org.hibernate.models.internal.util.ReflectionHelper;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.ClassBasedTypeDetails;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.ClassDetailsRegistry;
import org.hibernate.models.spi.ClassLoading;
import org.hibernate.models.spi.FieldDetails;
import org.hibernate.models.spi.MethodDetails;
import org.hibernate.models.spi.ModelsContext;
import org.hibernate.models.spi.MutableClassDetails;
import org.hibernate.models.spi.MutableMemberDetails;
import org.hibernate.models.spi.RecordComponentDetails;
import org.hibernate.models.spi.TypeDetails;
import org.hibernate.models.spi.TypeDetailsHelper;
import org.hibernate.models.spi.TypeVariableScope;

public class JdkMethodDetails
extends AbstractJdkAnnotationTarget
implements MethodDetails,
MutableMemberDetails {
    private final Method method;
    private final MethodDetails.MethodKind methodKind;
    private final TypeDetails type;
    private final ClassDetails declaringType;
    private final ClassDetails returnType;
    private final List<ClassDetails> argumentTypes;
    private final boolean isArray;
    private final boolean isPlural;

    public JdkMethodDetails(Method method, MethodDetails.MethodKind methodKind, TypeDetails type, ClassDetails declaringType, ModelsContext modelsContext) {
        super(method::getAnnotations, modelsContext);
        this.method = method;
        this.methodKind = methodKind;
        this.type = type;
        this.declaringType = declaringType;
        ClassDetailsRegistry classDetailsRegistry = modelsContext.getClassDetailsRegistry();
        this.returnType = classDetailsRegistry.resolveClassDetails(method.getReturnType().getName());
        this.argumentTypes = new ArrayList<ClassDetails>(method.getParameterCount());
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            this.argumentTypes.add(classDetailsRegistry.resolveClassDetails(method.getParameterTypes()[i].getName()));
        }
        switch (methodKind) {
            case GETTER: {
                this.isArray = method.getReturnType().isArray();
                this.isPlural = this.isArray || type.isImplementor(Collection.class) || type.isImplementor(Map.class);
                break;
            }
            case SETTER: {
                assert (method.getParameterCount() == 1);
                this.isArray = method.getParameterTypes()[0].isArray();
                this.isPlural = this.isArray || type.isImplementor(Collection.class) || type.isImplementor(Map.class);
                break;
            }
            default: {
                this.isArray = false;
                this.isPlural = false;
            }
        }
    }

    public Method getMethod() {
        return this.method;
    }

    @Override
    public String getName() {
        return this.method.getName();
    }

    @Override
    public MethodDetails.MethodKind getMethodKind() {
        return this.methodKind;
    }

    @Override
    public TypeDetails getType() {
        return this.type;
    }

    @Override
    public ClassDetails getDeclaringType() {
        return this.declaringType;
    }

    @Override
    public boolean isPlural() {
        return this.isPlural;
    }

    @Override
    public boolean isArray() {
        return this.isArray;
    }

    @Override
    public Method toJavaMember() {
        return this.method;
    }

    @Override
    public Method toJavaMember(Class<?> declaringClass, ClassLoading classLoading, ModelsContext modelContext) {
        if (declaringClass == this.method.getDeclaringClass()) {
            return this.method;
        }
        return ReflectionHelper.resolveJavaMember(this, declaringClass, classLoading, modelContext);
    }

    @Override
    public TypeDetails resolveRelativeType(TypeVariableScope container) {
        if (this.methodKind == MethodDetails.MethodKind.GETTER || this.methodKind == MethodDetails.MethodKind.SETTER) {
            return this.type.determineRelativeType(container);
        }
        throw new IllegalStateException("Method does not have a type - " + String.valueOf(this));
    }

    @Override
    public ClassBasedTypeDetails resolveRelativeClassType(TypeVariableScope container) {
        if (this.methodKind == MethodDetails.MethodKind.GETTER || this.methodKind == MethodDetails.MethodKind.SETTER) {
            return TypeDetailsHelper.resolveRelativeClassType(this.type, container);
        }
        throw new IllegalStateException("Method does not have a type - " + String.valueOf(this));
    }

    @Override
    public int getModifiers() {
        return this.method.getModifiers();
    }

    @Override
    public ClassDetails getReturnType() {
        return this.returnType;
    }

    @Override
    public List<ClassDetails> getArgumentTypes() {
        return this.argumentTypes;
    }

    public String toString() {
        return String.format(Locale.ROOT, "JdkMethodDetails( [%s] %s )", this.methodKind.name(), this.method.toString());
    }

    @Override
    public MethodDetails asMethodDetails() {
        return this;
    }

    @Override
    public MutableMemberDetails asMemberDetails() {
        return this;
    }

    @Override
    public FieldDetails asFieldDetails() {
        throw new IllegalCastException("MethodDetails cannot be cast as FieldDetails");
    }

    @Override
    public RecordComponentDetails asRecordComponentDetails() {
        throw new IllegalCastException("MethodDetails cannot be cast as RecordComponentDetails");
    }

    @Override
    public MutableClassDetails asClassDetails() {
        throw new IllegalCastException("MethodDetails cannot be cast as ClassDetails");
    }

    @Override
    public <A extends Annotation> AnnotationDescriptor<A> asAnnotationDescriptor() {
        throw new IllegalCastException("MethodDetails cannot be cast as AnnotationDescriptor");
    }
}

