/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal;

import java.lang.reflect.Modifier;
import org.hibernate.models.spi.MemberDetails;

public class ModifierUtils {
    public static final int BRIDGE = 64;
    public static final int SYNTHETIC = 4096;
    public static final int DYNAMIC_ATTRIBUTE_MODIFIERS = -5337;

    private ModifierUtils() {
    }

    public static MemberDetails.Visibility resolveVisibility(int modifierFlags) {
        if (Modifier.isPublic(modifierFlags)) {
            return MemberDetails.Visibility.PUBLIC;
        }
        if (Modifier.isProtected(modifierFlags)) {
            return MemberDetails.Visibility.PROTECTED;
        }
        if (Modifier.isPrivate(modifierFlags)) {
            return MemberDetails.Visibility.PRIVATE;
        }
        return MemberDetails.Visibility.PACKAGE;
    }

    public static boolean isTransient(int modifierFlags) {
        return Modifier.isTransient(modifierFlags);
    }

    public static boolean isStatic(int modifierFlags) {
        return Modifier.isStatic(modifierFlags);
    }

    public static boolean isFinal(int modifierFlags) {
        return Modifier.isFinal(modifierFlags);
    }

    public static boolean isSynthetic(int modifierFlags) {
        return (modifierFlags & 0x1000) != 0;
    }

    public static boolean isBridge(int modifierFlags) {
        return (modifierFlags & 0x40) != 0;
    }

    public static boolean isAbstract(int modifierFlags) {
        return (modifierFlags & 0x400) != 0;
    }

    public static boolean hasPersistableFieldModifiers(int modifierFlags) {
        return !ModifierUtils.isTransient(modifierFlags) && !ModifierUtils.isSynthetic(modifierFlags) && !ModifierUtils.isStatic(modifierFlags);
    }

    public static boolean hasPersistableMethodModifiers(int modifierFlags) {
        return !ModifierUtils.isStatic(modifierFlags) && !ModifierUtils.isBridge(modifierFlags) && !ModifierUtils.isTransient(modifierFlags) && !ModifierUtils.isSynthetic(modifierFlags);
    }
}

