/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBundleBuildItem;
import io.quarkus.runtime.annotations.RegisterResourceBundle;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;

public class RegisterResourceBundleBuildStep {
    @BuildStep
    public void build(CombinedIndexBuildItem combinedIndexBuildItem, BuildProducer<NativeImageResourceBundleBuildItem> resourceBundle) {
        for (AnnotationInstance annotationInstance : combinedIndexBuildItem.getIndex().getAnnotations(DotName.createSimple((String)RegisterResourceBundle.class.getName()))) {
            AnnotationValue bundleNameValue = annotationInstance.value("bundleName");
            AnnotationValue moduleNameValue = annotationInstance.value("moduleName");
            if (moduleNameValue == null || moduleNameValue.asString().isEmpty()) {
                resourceBundle.produce(new NativeImageResourceBundleBuildItem(bundleNameValue.asString()));
                continue;
            }
            resourceBundle.produce(new NativeImageResourceBundleBuildItem(bundleNameValue.asString(), moduleNameValue.asString()));
        }
    }
}

