/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.dev.testing;

import io.quarkus.deployment.dev.testing.TestConfig;
import io.quarkus.runtime.LaunchMode;
import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigSourceInterceptorFactory;
import io.smallrye.config.FallbackConfigSourceInterceptor;
import io.smallrye.config.SmallRyeConfigBuilder;
import io.smallrye.config.SmallRyeConfigBuilderCustomizer;
import java.util.function.Function;

public class TestConfigCustomizer
implements SmallRyeConfigBuilderCustomizer {
    private final LaunchMode launchMode;

    public TestConfigCustomizer(LaunchMode launchMode) {
        this.launchMode = launchMode;
    }

    public void configBuilder(SmallRyeConfigBuilder builder) {
        builder.withDefaultValue("quarkus.profile", this.launchMode.getDefaultProfile());
        builder.withMapping(TestConfig.class);
        builder.withInterceptorFactories(new ConfigSourceInterceptorFactory[]{new ConfigSourceInterceptorFactory(){

            public ConfigSourceInterceptor getInterceptor(ConfigSourceInterceptorContext context) {
                return new FallbackConfigSourceInterceptor((Function)new Function<String, String>(){

                    @Override
                    public String apply(String name) {
                        if (name.equals("quarkus.test.integration-test-profile")) {
                            return "quarkus.profile";
                        }
                        return name;
                    }
                });
            }
        }});
    }

    public int priority() {
        return super.priority();
    }
}

